
## ----echo=FALSE,results="hide"-------------------------------------------
date()


## ----echo=FALSE,results="hide"-------------------------------------------
library(knitcitations)
library(bibtex)
allbib = read.bibtex("allbib.bib")
library(GGtools)


## ----dolo,echo=FALSE-----------------------------------------------------
load("f1.rda")


## ----lookf1,echo=TRUE----------------------------------------------------
length(f1)
f1[1:3]
metadata(f1)


## ----demoy,fig=TRUE,fig.width=7,fig.height=4,echo=FALSE,results="hide"----
library(yri1kgv)
if (!exists("c20")) c20 = getSS("yri1kgv", "chr20")
par(mfrow=c(1,2))
plot_EvG(probeId("o67h4JQSuEa02CJJIQ"), rsid("rs2259928"), c20,
  main="observed expr.")
if (!exists("c20f")) c20f = clipPCs(c20, 1:10)
plot_EvG(probeId("o67h4JQSuEa02CJJIQ"), rsid("rs2259928"), c20f,
  main="10 expr. PC removed")


## ----bag,fig=TRUE,fig.width=4,fig.height=4,echo=FALSE--------------------
library(snpStats)
library(scatterplot3d)
tmp = as.raw(1:253)
yy = g2post(tmp)
EB = yy %*% c(0,1,2) 
scatterplot3d(yy[,1], yy[,3], EB, xlab="Pr(A/A)", ylab="Pr(B/B)", zlab="mean num. B")


## ----bag2----------------------------------------------------------------
library(GGtools)
library(yri1kgv)
library(lumiHumanAll.db)
if (!exists("y22")) y22 = getSS("yri1kgv", "chr22")
y22
dim(exprs(y22))
fn = featureNames(y22)[1:5]
library(lumi)
id2seq(fn) # get the 50mer for each probe
# and some annotation
select( lumiHumanAll.db, keys=fn, keytype="PROBEID", columns=c("SYMBOL", "CHR", "ENTREZID"))
gt22 <- smList(y22)[[1]]  # access to genotypes
as( gt22[1:5,1:5], "character" )
cs22 = col.summary(gt22)  # some information on genotypes
cs22[1:10,]


## ----lkhi,eval=FALSE-----------------------------------------------------
## ciseqByCluster( pack = "yri1kgv", chromsToRun=20:22,
##    numNodes=3, ncoresPerNode=4, targetfolder="./yrex1"  )


## ----setup,eval=FALSE----------------------------------------------------
## #
## # this program will split all chromsomes in roughly equal halves (by probe) and
## # compute All.cis for all probes ... snps may recur in the different halves
## #
##   if (!file.exists(targetfolder)) try(system(paste0("mkdir ", targetfolder)))
##   if (!file.exists(targetfolder)) stop(paste0("cannot  create ", targetfolder))
##   library(parallel)
##   cl <<- makePSOCKcluster(nodeNames)


## ----splitters,eval=FALSE------------------------------------------------
##   firstHalf <<- function(x) x[1:floor(length(x))/2]
##   secondHalf <<- function(x) x[-(1:floor(length(x))/2)]


## ----configSet,eval=FALSE------------------------------------------------
##   setupSplit = function(nodeset=1:numNodes) {
##      clusterApply(cl, nodeset, function(w) {
##       library(parallel)  # get resources
##       library(GGtools)
##       library(pack, character.only=TRUE)
##       library(geneannopk, character.only=TRUE)
##       library(snpannopk, character.only=TRUE)
##       library(Rsamtools)
##       library(rtracklayer)
##       cc = new("CisConfig")  # configure search, except for choice of chromosome
##       smpack(cc) = pack
##       nperm(cc) = nperm
##       geneannopk(cc) = geneannopk
##       radius(cc) = radius
##       smchrpref(cc) = smchrpref
##       geneApply(cc) = mclapply  # so genes are dispatched to cores
##       options(mc.cores=ncoresPerNode)
##       cc <<- cc
##      } )
##   }
##   setupSplit(1:numNodes)  # causes library attachment on all nodes and generation of CisConfig instances there


## ----chromSpecific,eval=FALSE--------------------------------------------
##   runOneSplit <<- function(chrtag, suffix="A", splitter=firstHalf, gffOnly=TRUE) { # assumes cc is defined locally as the config
##     if (!exists("cc")) stop("did not find cc for local CisConfig manipulation")
##     chrnames(cc) = as.character(chrtag)
##     folderStem(cc) = paste0(folderStem(cc), "_", chrtag, suffix)
##     smFilter(cc) = function(x) {   # late filtering
##         fn = featureNames(x);
##         if (numPCtoFilter > 0) tmp = MAFfilter( clipPCs(x, 1:numPCtoFilter), lower=lowerMAF )
##         else tmp = MAFfilter( x, lower=lowerMAF )
##         tmp[probeId(splitter(fn)),]
##         }
##     obn = paste0(outprefix, "_", chrnames(cc), suffix)
##     fn = paste0(obn, ".rda")
##     res <- try(All.cis(cc))
##     if (inherits(res, "try-error")) return(res)
## 
##           getmindist = function(snplocs, probes, geneannopk="lumiHumanAll.db") {
##            require(geneannopk, character.only=TRUE, quietly=TRUE)
##            stub = gsub(".db$", "", geneannopk)
##            locenv = get(paste0(stub, "CHRLOC"))
##            locendenv = get(paste0(stub, "CHRLOCEND"))
##            gloc = abs(sapply(mget(probes, locenv), "[", 1))
##            gend = abs(sapply(mget(probes, locendenv), "[", 1))
##            ifelse(
##                     snplocs <= gend & snplocs >= gloc, 0,
##                     ifelse( snplocs > gend, snplocs-gend, gloc-snplocs ) )
##           }
##     res$mindist = getmindist(res$snplocs, res$probeid, geneannopk=geneannopk)
##     assign(obn, res)
## 
##     if(!gffOnly) {
##        save(list=obn, file=fn)    # save to local disk
##        system(paste0("cp ", fn, " ", targetfolder ))  # copy to target folder
##        }
## #
## #
## # define transformer
##   cr2gff = function(cr, obn, targetfolder=".") {
##       require(GenomicRanges)
##       require(Rsamtools)
##       res = as(cr, "GRanges")
##       sl = IRanges(res$snplocs, width=1)
##       ranges(res) = sl
##       names(res) = NULL
##       sn = seqnames(res)
##       sn = gsub("chr", "", sn)
##       o = order( as.numeric(sn), start(res) )
##       res = res[o]
##       gffFile = paste0(targetfolder, "/", obn, ".gff3")
##   #    seqlevels(res) = gsub("chr", "", seqlevels(res))
##       export.gff3( res, gffFile )
##  #     owd = getwd()
##  #     setwd(targetfolder)
##  #     bgzip( gffFile , overwrite=TRUE)
##  #     indexTabix( paste0(gffFile, ".gz") , format="gff")
##  #     setwd( owd )
##   }
## #
## # continue processing to tabix-indexed gff3 based on SNP address
## #
##     cr2gff( as(res, "GRanges"), obn, targetfolder )
##     NULL
##   }


## ----push2sl,eval=FALSE--------------------------------------------------
##   clusterExport(cl, "runOneSplit")
##   clusterExport(cl, "firstHalf")
##   clusterExport(cl, "secondHalf")


## ----makeRequest,eval=FALSE----------------------------------------------
##   njobs = 2*length(chromsToRun)
##   chrtags = as.character(rep(chromsToRun, each=2))
## 
##   reqlist = vector("list", njobs)
##   j <- 1
##   for (i in 1:length(chrtags)) {
##    reqlist[[j]] = list( chr=chrtags[j], tag="A", splitter=firstHalf )  # need to distinguish splitter elements
##    reqlist[[j+1]] = list( chr=chrtags[j+1], tag="B", splitter=secondHalf )  # therefore loop is complex
##    j <- j+2
##   }
##   reqlist <<- reqlist


## ----disp2slaves,eval=FALSE----------------------------------------------
##   clusterApplyLB(cl, reqlist, function(x) runOneSplit(x[["chr"]], x[["tag"]], x[["splitter"]]))
## #}


## ----results='asis',echo=FALSE-------------------------------------------
bibliography() #style="markdown")


