#!/bin/sh

set -e  # Exit immediately if a simple command exits with a non-zero status

# We keep strict SNPs only (tagged "snp") i.e. we drop lines tagged as
#   "in-del", "mixed", "microsatellite", "named-locus" or "multinucleotide-polymorphism"
grep '| snp |' | \
  grep '| notwithdrawn |' | \
  # Filtering out SNPs with multiple reported locations on GRCh37.p2
  grep -v '| CTG | assembly=GRCh37.p2 |.*| CTG | assembly=GRCh37.p2 |' | \
  grep "| CTG | assembly=GRCh37.p2 | chr=$1 |" | \
  # Filtering out SNPs with an unspecified location on GRCh37.p2
  grep -v "| CTG | assembly=GRCh37.p2 | chr=$1 | chr-pos=? |" | \
  sed -r 's/\| notwithdrawn (\||\|.*\|) CTG \| assembly=GRCh37.p2 \|/|/'

