\name{MeSH.db}
\alias{MeSH.db}
\title{Annotation package that provides correspondence between MeSH ID and Entrez Gene ID}
\description{This data represents a collection of annotation packages that can be used as a single object named as package name. This object can be used with the standard four accessor method for all AnnotationDbi objects.  Namely: \code{columns}, \code{keytypes}, \code{keys} and \code{select}.  Users are encouraged to read the vignette from the \code{MeSHDbi} package for more details.}
\author{Itoshi NIKAIDO}
\usage{MeSH.db}
\examples{
library(MeSH.db)
MeSH.db

cls <- columns(MeSH.db)
cls
kts <- keytypes(MeSH.db)
kt <- kts[2]
kts
ks <- head(keys(MeSH.db, keytype=kts[2]))
ks
res <- select(MeSH.db, keys=ks, columns=cls, keytype=kt)
head(res)

dbconn(MeSH.db)
dbfile(MeSH.db)
dbschema(MeSH.db)
dbInfo(MeSH.db)
}
