### R code from vignette source 'deepSNV.Rnw'

###################################################
### code chunk number 1: deepSNV.Rnw:59-60
###################################################
	print(citation("deepSNV"), style="LaTeX")


###################################################
### code chunk number 2: deepSNV.Rnw:69-71
###################################################
    library(deepSNV)
	regions <- data.frame(chr="B.FR.83.HXB2_LAI_IIIB_BRU_K034", start = 2074, stop=3585)


###################################################
### code chunk number 3: deepSNV.Rnw:83-85
###################################################
	data(HIVmix) # Attach the data instead, as it could fail in routine checks without internet connection.
	show(HIVmix)


###################################################
### code chunk number 4: deepSNV.Rnw:88-90
###################################################
	control(HIVmix)[100:110,]
	test(HIVmix)[100:110,]


###################################################
### code chunk number 5: HIV
###################################################
	plot(HIVmix)


###################################################
### code chunk number 6: deepSNV.Rnw:104-108
###################################################
	SNVs <- summary(HIVmix, sig.level=0.05, adjust.method="BH")
	head(SNVs)
	nrow(SNVs)
	min(SNVs$freq.var)


###################################################
### code chunk number 7: deepSNV.Rnw:112-113
###################################################
	sum(RF(test(HIVmix), total=T) > 0.01 & RF(test(HIVmix), total=T) < 0.95)


###################################################
### code chunk number 8: deepSNV.Rnw:117-119
###################################################
	data(trueSNVs, package="deepSNV")
	table(p.adjust(p.val(HIVmix), method="BH") < 0.05, trueSNVs)


###################################################
### code chunk number 9: phiX
###################################################
	data(phiX, package="deepSNV")
	jpeg("deepSNV-phiX.jpg", 2.5, 2.5, units="in", res=600, pointsize=7)
	par(mar=c(4,4,1,1), bty="n")
	plot(phiX, cex.min=.5)
	dev.off()


###################################################
### code chunk number 10: phiN
###################################################
    phiN <- normalize(phiX, round=TRUE)
	jpeg("deepSNV-phiN.jpg", 2.5, 2.5, units="in", res=600, pointsize=7)
	par(mar=c(4,4,1,1), bty="n")
    plot(phiN, cex.min=.5)
	dev.off()


###################################################
### code chunk number 11: pval
###################################################
	p.norm <- p.val(phiN)
    n <- sum(!is.na(p.norm))
    qqplot(p.norm, seq(1/n,1, length.out=n), log="xy", type="S", xlab="P-value", ylab="CDF")
	p.val <- p.val(phiX) 
    points(sort(p.val[!is.na(p.val)]), seq(1/n,1, length.out=n), pch=16, col="grey", type="S", lty=2)
    legend("topleft", c("raw data", "normalized data"), pch=16, col=c("grey", "black"), bty="n", lty=3)
    abline(0,1)


###################################################
### code chunk number 12: deepSNV.Rnw:199-201
###################################################
	data("RCC", package="deepSNV")
	show(RCC)


###################################################
### code chunk number 13: RCC-bin
###################################################
	jpeg("deepSNV-RCC-bin.jpg", 2.5, 2.5, units="in", res=600, pointsize=7)
	par(mar=c(4,4,1,1), bty="n")
	plot(RCC, cex.min=.5) 
	dev.off()


###################################################
### code chunk number 14: deepSNV.Rnw:221-222
###################################################
RCC.bb = estimateDispersion(RCC, alternative="two.sided")


###################################################
### code chunk number 15: RCC-bb
###################################################
	jpeg("deepSNV-RCC-bb.jpg", 2.5, 2.5, units="in", res=600, pointsize=7)
	par(mar=c(4,4,1,1), bty="n")
	plot(RCC.bb, cex.min=.5) 
	dev.off()


###################################################
### code chunk number 16: deepSNV.Rnw:232-236
###################################################
	RCC.bb@log.lik 
	RCC@log.lik
    RCC.bb@log.lik - RCC@log.lik
	log(4*nrow(test(RCC)))


###################################################
### code chunk number 17: deepSNV.Rnw:242-243
###################################################
	summary(RCC, adjust.method="bonferroni")[,1:6]


###################################################
### code chunk number 18: deepSNV.Rnw:247-249
###################################################
	tab <- summary(RCC.bb, adjust.method="bonferroni")[,1:6]
	tab


###################################################
### code chunk number 19: deepSNV.Rnw:258-259
###################################################
    toLatex(sessionInfo())


