### R code from vignette source 'SANTA.Rnw'

###################################################
### code chunk number 1: Ropts
###################################################
options(width=70)


###################################################
### code chunk number 2: SANTA.Rnw:201-206
###################################################
library(SANTA)
data(treated.dataframe)
data(untreated.dataframe)
g.treated <- graph.data.frame(treated.dataframe, directed=FALSE )
g.untreated <- graph.data.frame(untreated.dataframe, directed=FALSE)


###################################################
### code chunk number 3: SANTA.Rnw:213-221
###################################################
name.treated <- get.vertex.attribute(g.treated, "name")
name.untreated <- get.vertex.attribute(g.untreated, "name")
mis.treated <- name.untreated[which(! name.untreated %in% name.treated)]
mis.untreated <- name.treated[which(! name.treated %in% name.untreated)]
g.treated <- add.vertices(g.treated, length(mis.treated), 
	attr=list(name=mis.treated))
g.untreated <- add.vertices(g.untreated, length(mis.untreated), 
	attr=list(name=mis.untreated))


###################################################
### code chunk number 4: SANTA.Rnw:226-233
###################################################
library(org.Sc.sgd.db)
xx <- as.list(org.Sc.sgdGO2ALLORFS)
associated.genes <- xx[["GO:0006974"]]
association.treated <- as.numeric(get.vertex.attribute(g.treated, 
	"name") %in% associated.genes)
association.untreated <- as.numeric(get.vertex.attribute(g.untreated, 
	"name") %in% associated.genes)


###################################################
### code chunk number 5: SANTA.Rnw:238-242
###################################################
g.treated <- set.vertex.attribute(g.treated, 
	name="rdds", value=association.treated)
g.untreated <- set.vertex.attribute(g.untreated, 
	name="rdds", value=association.untreated)


###################################################
### code chunk number 6: SANTA.Rnw:247-253
###################################################
s.treated <- get.edge.attribute(g.treated, name="gi-score")
s.untreated <- get.edge.attribute(g.untreated, name="gi-score")
g.treated <- set.edge.attribute(g.treated, name="distance", 
	value=max(abs(s.treated)) - abs(s.treated))
g.untreated <- set.edge.attribute(g.untreated, name="distance", 
	value=max(abs(s.untreated)) - abs(s.untreated))


###################################################
### code chunk number 7: SANTA.Rnw:260-266
###################################################
res.treated <- Knet(g.treated, nperm=100, dist.method="shortest.paths",  
	vertex.attr="rdds")
res.untreated <- Knet(g.untreated, nperm=100, dist.method="shortest.paths", 
	vertex.attr="rdds")
res.treated$pval
res.untreated$pval


###################################################
### code chunk number 8: fig1plot
###################################################
plot(res.treated)


###################################################
### code chunk number 9: fig2plot
###################################################
plot(res.untreated)


###################################################
### code chunk number 10: fig1
###################################################
plot(res.treated)


###################################################
### code chunk number 11: fig2
###################################################
plot(res.untreated)


###################################################
### code chunk number 12: SANTA.Rnw:312-315
###################################################
library(SANTA)
data(treated.dataframe)
g.treated <- graph.data.frame(treated.dataframe, directed=FALSE)


###################################################
### code chunk number 13: SANTA.Rnw:320-327
###################################################
library(org.Sc.sgd.db)
xx <- as.list(org.Sc.sgdGO2ALLORFS)
associated.genes <- xx[["GO:0006974"]]
association.values <- as.numeric(get.vertex.attribute(g.treated, 
	"name") %in% associated.genes)
g.treated <- set.vertex.attribute(g.treated, name="rdds", 
	value=association.values)


###################################################
### code chunk number 14: SANTA.Rnw:332-335
###################################################
s.treated <- get.edge.attribute(g.treated, name="gi-score")
g.treated <- set.edge.attribute(g.treated, name="distance", 
	value=max(abs(s.treated)) - abs(s.treated))


###################################################
### code chunk number 15: SANTA.Rnw:342-344
###################################################
res <- Knode(g.treated, vertex.attr="rdds", only.Knode=FALSE)
res[1:10, 1:2]


###################################################
### code chunk number 16: SANTA.Rnw:349-350
###################################################
res[res[,2]!=1, ][1:10, 1:2]


###################################################
### code chunk number 17: SANTA.Rnw:362-363
###################################################
toLatex(sessionInfo())


