/*
 * Decompiled with CFR 0.152.
 */
package reder.network;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reder.application.MainFrame;
import reder.network.EdgeBank;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeBank {
    protected ArrayList<Integer> partnerList;
    protected ArrayList<Integer> containerComponentsList;
    protected ArrayList<Integer> ContainerEdgeMapListUnique;
    protected ArrayList<Integer> InContainerSimpleEdgeMapList;
    protected ArrayList<Integer> OutContainerSimpleEdgeMapList;
    protected ArrayList<Integer> treeComponentsList;
    protected Hashtable keyPartnerList;
    private final float w0;
    private final float h0;
    private Color nodeColor;
    private Color lineColor;
    private Color fontColor;
    protected float x;
    protected float y;
    protected float w;
    protected float h;
    private float bufferX;
    private float bufferY;
    private float xToSave;
    private float yToSave;
    private float nodeSize;
    private float nodeBend;
    private int numParceiros;
    private int fonteSize;
    private String aliases;
    private String nodeShape;
    private Point2D ponto;
    private float lineWith;
    private Font font;
    private float fontPositionX;
    private float fontPositionY;
    private final Color corDestaque;
    private final Color corDestaqueLinha;
    protected boolean destaque;
    protected boolean containertreemark;
    protected double dx;
    protected double dy;
    protected double veloxy;
    protected double nveloxy;
    private double nodeWeight;
    private double normalizedWeight;
    private boolean isGrupo;
    private boolean displayLegend;
    private boolean isClusterAssigned;
    private String groupComponets;
    private int groupCompNumber;
    private int clusterID;
    private boolean isUnderPairwise;
    protected String nestedAssignment;
    private boolean isNestedNode;
    private boolean isContainerAnchored;
    private boolean isContainer;
    private boolean destaqueTree;
    private boolean nodeGradient;
    private boolean isMockNode;
    private boolean isTransformed;
    private boolean isContainerHided;
    private boolean isContainerTransparent;
    private boolean isDragged;
    private boolean isCopy;
    private int treeSize;
    private int treeLevels;
    private int nodeLevel;
    private int networkPartition;
    private int nVirtualAssociations;
    private String lineType;
    private String strNodeID;
    private final int intNodeID;
    private double relativeSize;
    private double highlightSize;
    private int nestedPosition;
    private double nestedVelox;
    protected NodeBank thisNodeAccount;
    protected NodeBank newContainer;
    protected NodeBank component;
    protected NodeBank nodeCopyAccount;
    protected EdgeBank edgeCopyAccount;
    protected EdgeBank edgeOriginalAccount;

    public NodeBank(String strNodeID, int intNodeID) {
        this.strNodeID = strNodeID;
        this.intNodeID = intNodeID;
        this.nodeWeight = 0.0;
        this.normalizedWeight = 0.0;
        this.aliases = this.strNodeID;
        this.numParceiros = 0;
        this.corDestaque = new Color(255, 204, 0);
        this.corDestaqueLinha = new Color(200, 160, 0);
        this.partnerList = new ArrayList();
        this.ContainerEdgeMapListUnique = new ArrayList();
        this.InContainerSimpleEdgeMapList = new ArrayList();
        this.OutContainerSimpleEdgeMapList = new ArrayList();
        this.nVirtualAssociations = 0;
        this.containerComponentsList = new ArrayList();
        this.treeComponentsList = new ArrayList();
        this.keyPartnerList = new Hashtable();
        this.h0 = 20.0f;
        this.w0 = 20.0f;
        this.resetNodeAccount();
    }

    public int getFinalID() {
        return this.intNodeID;
    }

    private void resetNodeAccount() {
        this.nodeColor = new Color(255, 204, 204);
        this.lineColor = new Color(153, 153, 255);
        this.fontColor = new Color(51, 51, 51);
        this.destaque = false;
        this.x = (float)Math.random() * 600.0f;
        this.y = (float)Math.random() * 400.0f;
        this.xToSave = this.x;
        this.yToSave = this.y;
        this.bufferX = this.x;
        this.bufferY = this.y;
        this.fontPositionX = 10.0f;
        this.fontPositionY = 12.0f;
        this.h = 20.0f;
        this.w = 20.0f;
        this.nodeBend = 50.0f;
        this.nodeSize = 1.0f;
        this.ponto = new Point2D.Double(this.x, this.y);
        this.lineWith = 1.0f;
        this.fonteSize = 12;
        this.font = new Font("Arial", 0, this.fonteSize);
        this.nodeShape = "ELLIPSE";
        this.lineType = "SOLID";
        this.isGrupo = false;
        this.groupComponets = "";
        this.groupCompNumber = 0;
        this.displayLegend = true;
        this.clusterID = 0;
        this.isClusterAssigned = false;
        this.isUnderPairwise = false;
        this.resetRelax();
        this.isNestedNode = false;
        this.isContainer = false;
        this.isContainerHided = false;
        this.isContainerTransparent = false;
        this.nestedAssignment = "assignRoot_meaninglessCode1245ty890xyz";
        this.destaqueTree = false;
        this.containertreemark = false;
        this.nodeGradient = false;
        this.isContainerAnchored = false;
        this.isCopy = false;
        this.relativeSize = 1.0;
        this.highlightSize = 1.0;
        this.treeSize = 0;
        this.treeLevels = 0;
        this.nodeLevel = 0;
        this.networkPartition = 0;
        this.nestedPosition = 0;
        this.nestedVelox = 1.0;
        this.isDragged = false;
        this.isMockNode = false;
        this.isTransformed = false;
    }

    public boolean addParceiro(int parceiro) {
        boolean deposito = false;
        if (this.partnerList.isEmpty()) {
            this.partnerList.add(new Integer(parceiro));
            this.keyPartnerList.put(parceiro, new Integer(this.numParceiros));
            ++this.numParceiros;
            deposito = true;
        } else if (!this.keyPartnerList.containsKey(parceiro)) {
            this.partnerList.add(new Integer(parceiro));
            this.keyPartnerList.put(parceiro, new Integer(this.numParceiros));
            ++this.numParceiros;
            deposito = true;
        }
        return deposito;
    }

    public ArrayList<Integer> getParceiros() {
        return this.partnerList;
    }

    public boolean isPartner(int par) {
        return this.keyPartnerList.containsKey(par);
    }

    public int getNumParceiros() {
        return this.numParceiros;
    }

    public void resetParceiros() {
        this.partnerList.clear();
        this.keyPartnerList.clear();
        this.numParceiros = 0;
    }

    public void addContainerEdgeUnique(int edgeID) {
        this.ContainerEdgeMapListUnique.add(new Integer(edgeID));
    }

    public ArrayList<Integer> getContainerEdgeMapUnique() {
        return this.ContainerEdgeMapListUnique;
    }

    public void resetContainerEdgeMap() {
        this.ContainerEdgeMapListUnique.clear();
    }

    public void addInContainerSimpleEdge(int edgeID) {
        this.InContainerSimpleEdgeMapList.add(new Integer(edgeID));
    }

    public ArrayList<Integer> getInContainerSimpleEdges() {
        return this.InContainerSimpleEdgeMapList;
    }

    public void resetInContainerSimpleEdges() {
        this.InContainerSimpleEdgeMapList.clear();
    }

    public void addOutContainerSimpleEdge(int edgeID) {
        this.OutContainerSimpleEdgeMapList.add(new Integer(edgeID));
    }

    public ArrayList<Integer> getOutContainerSimpleEdges() {
        return this.OutContainerSimpleEdgeMapList;
    }

    public void resetOutContainerSimpleEdges() {
        this.OutContainerSimpleEdgeMapList.clear();
    }

    public void setAsGroup(boolean status) {
        this.isGrupo = status;
    }

    public void setGroupComponents(String comp) {
        this.groupComponets = this.groupCompNumber == 0 ? comp : comp + ";" + this.groupComponets;
        ++this.groupCompNumber;
    }

    public void setGroupCompNumber(int number) {
        this.groupCompNumber = number;
    }

    public void setGroupSize(float size) {
        this.setNodeSize((float)Math.sqrt(size));
    }

    public boolean isGroup() {
        return this.isGrupo;
    }

    public String getGroupComponets() {
        return this.groupComponets;
    }

    public int getGroupCompNumber() {
        return this.groupCompNumber;
    }

    public void assignClusterID(int assignID, int numClusters) {
        this.isClusterAssigned = true;
        this.clusterID = assignID;
        double a = this.clusterID + 1;
        double b = numClusters;
        double fIn = a / b * Math.pow(255.0, 3.0);
        if (fIn >= Math.pow(255.0, 3.0) / 2.0) {
            int fOut = (int)((a / b - 0.5) / 0.5 * 255.0);
            this.nodeColor = new Color(fOut, 255 - fOut, 0);
            this.lineColor = new Color(fOut, 255 - fOut, 0);
        } else {
            int fOut = (int)(a / b / 0.5 * 255.0);
            this.nodeColor = new Color(0, 255 - fOut, fOut);
            this.lineColor = new Color(0, 255 - fOut, fOut);
        }
    }

    public int getClusterID() {
        return this.clusterID;
    }

    public boolean isClusterAssigned() {
        return this.isClusterAssigned;
    }

    public void setNodeNested(String nestID) {
        this.nestedAssignment = nestID;
        this.isNestedNode = true;
    }

    public String getNestedAssignment() {
        return this.nestedAssignment;
    }

    public int getNestedAssignmentIndx() {
        if (!this.isNestedNode) {
            return -1;
        }
        int idx = MainFrame.keyNodeArray.indexOf(this.nestedAssignment);
        return idx;
    }

    public void resetNestedAssignment() {
        this.isNestedNode = false;
        this.nestedAssignment = "assignRoot_meaninglessCode1245ty890xyz";
    }

    public boolean isNodeNested() {
        return this.isNestedNode;
    }

    public void setNestedPosition(int position) {
        this.nestedPosition = position;
    }

    public int getNestedPosition() {
        return this.nestedPosition;
    }

    public void setNestedVelox(double velox) {
        this.nestedVelox = velox;
    }

    public double getNestedVelox() {
        return this.nestedVelox;
    }

    public void setContainer(boolean status) {
        this.isContainer = status;
    }

    public void setTransformed(boolean bb) {
        this.isTransformed = bb;
    }

    public boolean isTransformed() {
        return this.isTransformed;
    }

    public void nodeTransform() {
        if (this.isContainer) {
            return;
        }
        this.setContainer(true);
        this.updateContainer();
        this.setNodeGradient(true);
    }

    public void setRelativeSize(double sz) {
        double inSz = sz / this.relativeSize;
        for (int i = 0; i < this.containerComponentsList.size(); ++i) {
            NodeBank updateTree = MainFrame.NodeList.get(this.containerComponentsList.get(i));
            double outSz = updateTree.getRelativeSize() * inSz;
            updateTree.setRelativeSize(outSz);
        }
        this.relativeSize *= inSz;
    }

    public double getRelativeSize() {
        double rz = this.relativeSize * this.highlightSize;
        return rz;
    }

    public void setHighlightSize(double sz) {
        this.highlightSize = sz;
    }

    public double getHighlightSize() {
        return this.highlightSize;
    }

    public void addContainerComponent(int component) {
        if (this.containerComponentsList.isEmpty()) {
            this.containerComponentsList.add(new Integer(component));
        } else if (!this.containerComponentsList.contains(component)) {
            this.containerComponentsList.add(new Integer(component));
        }
    }

    public ArrayList<Integer> getContainerComponents() {
        return this.containerComponentsList;
    }

    public int getNumComponents() {
        return this.containerComponentsList.size();
    }

    public void resetContainerComponents() {
        this.containerComponentsList.clear();
    }

    public boolean isContainer() {
        boolean b = this.isContainer || this.isTransformed;
        return b;
    }

    public boolean isContainerHided() {
        return this.isContainerHided;
    }

    public boolean isContainerTransparent() {
        return this.isContainerTransparent;
    }

    public boolean isContainerAnchored() {
        return this.isContainerAnchored;
    }

    public void setContainerHided(boolean status) {
        this.isContainerHided = status;
    }

    public void setContainerTransparent(boolean status) {
        this.isContainerTransparent = status;
    }

    public void setContainerAnchored(boolean status) {
        this.isContainerAnchored = status;
    }

    public void updateContainer() {
        this.updateContainerCoord();
        double estimatedSize = this.getContainerSize(this.containerComponentsList);
        this.setNodeSize((float)estimatedSize);
    }

    private void updateContainerCoord() {
        if (this.containerComponentsList.isEmpty()) {
            return;
        }
        if (this.containerComponentsList.size() == 1) {
            int nestedNode = this.containerComponentsList.get(0);
            NodeBank nodeAccount = MainFrame.NodeList.get(nestedNode);
            this.x = nodeAccount.getX();
            this.y = nodeAccount.getY();
            return;
        }
        float containerX = 0.0f;
        float containerY = 0.0f;
        float maxX = -1.0E9f;
        float maxY = -1.0E9f;
        float minX = 1.0E9f;
        float minY = 1.0E9f;
        for (int k = 0; k < this.containerComponentsList.size(); ++k) {
            int nestedNode = this.containerComponentsList.get(k);
            NodeBank nodeAccount = MainFrame.NodeList.get(nestedNode);
            if (nodeAccount.isContainer()) {
                float raioW = this.w * (float)MainFrame.getZoom() * (float)this.relativeSize / 2.0f;
                float raioH = this.h * (float)MainFrame.getZoom() * (float)this.relativeSize / 2.0f;
                float Mx = nodeAccount.getX() + raioW;
                float mx = nodeAccount.getX() - raioW;
                float My = nodeAccount.getY() + raioH;
                float my = nodeAccount.getY() - raioH;
                if (maxX < Mx) {
                    maxX = Mx;
                }
                if (minX > mx) {
                    minX = mx;
                }
                if (maxY < My) {
                    maxY = My;
                }
                if (!(minY > my)) continue;
                minY = my;
                continue;
            }
            if (maxX < nodeAccount.getX()) {
                maxX = nodeAccount.getX();
            }
            if (minX > nodeAccount.getX()) {
                minX = nodeAccount.getX();
            }
            if (maxY < nodeAccount.getY()) {
                maxY = nodeAccount.getY();
            }
            if (!(minY > nodeAccount.getY())) continue;
            minY = nodeAccount.getY();
        }
        float dcx = maxX - minX;
        float dcy = maxY - minY;
        containerX = minX + dcx / 2.0f;
        containerY = minY + dcy / 2.0f;
        this.setX(containerX);
        this.setY(containerY);
    }

    public void updateContent() {
        if (this.containerComponentsList.size() == 1) {
            int nestedNode = this.containerComponentsList.get(0);
            NodeBank nodeAccount = MainFrame.NodeList.get(nestedNode);
            nodeAccount.setX(this.x);
            nodeAccount.setY(this.y);
            return;
        }
        double escala = 1.0 / Math.sqrt(2.0);
        double zoom = MainFrame.getZoom();
        double xMax = 0.0;
        double yMax = 0.0;
        double xMin = 1.0E8;
        double yMin = 1.0E8;
        for (int i = 0; i < this.containerComponentsList.size(); ++i) {
            int nestedNode = this.containerComponentsList.get(i);
            NodeBank nodeAccount = MainFrame.NodeList.get(nestedNode);
            double xx = nodeAccount.getX();
            double yy = nodeAccount.getY();
            if (xx > xMax) {
                xMax = xx;
            }
            if (yy > yMax) {
                yMax = yy;
            }
            if (xx < xMin) {
                xMin = xx;
            }
            if (!(yy < yMin)) continue;
            yMin = yy;
        }
        double length = Math.min((double)this.w * zoom, (double)this.h * zoom) * escala;
        double dxx = xMax - xMin;
        double dyy = yMax - yMin;
        double rescale = length / Math.max(dxx, dyy);
        double addx = ((double)(this.getX() * 2.0f) - dxx * rescale) / 2.0;
        double addy = ((double)(this.getY() * 2.0f) - dyy * rescale) / 2.0;
        for (int i = 0; i < this.containerComponentsList.size(); ++i) {
            int nestedNode = this.containerComponentsList.get(i);
            NodeBank nodeAccount = MainFrame.NodeList.get(nestedNode);
            double xx = ((double)nodeAccount.getX() - xMin) * rescale + addx;
            double yy = ((double)nodeAccount.getY() - yMin) * rescale + addy;
            if (nodeAccount.isContainer()) {
                nodeAccount.moveTree((float)xx, (float)yy);
                continue;
            }
            nodeAccount.setNode((float)xx, (float)yy);
        }
    }

    public void setDestaqueTree(boolean destaque) {
        block4: {
            this.destaqueTree = destaque;
            if (!this.isContainer) break block4;
            if (destaque) {
                for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                    NodeBank destacarComponentes = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                    destacarComponentes.setDestaqueTree(true);
                }
            } else {
                for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                    NodeBank destacarComponentes = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                    destacarComponentes.setDestaqueTree(false);
                }
            }
        }
    }

    public boolean getDestaqueTree() {
        return this.destaqueTree;
    }

    public void setContainerTreeMark(boolean marcar) {
        block4: {
            if (!this.isContainer) break block4;
            this.containertreemark = marcar;
            if (marcar) {
                for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                    NodeBank destacarComponentes = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                    destacarComponentes.setContainerTreeMark(true);
                }
            } else {
                for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                    NodeBank destacarComponentes = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                    destacarComponentes.setContainerTreeMark(false);
                }
            }
        }
    }

    public boolean getContainerTreeMark() {
        return this.containertreemark;
    }

    public ArrayList<Integer> updateTreeComponents() {
        this.treeComponentsList.clear();
        this.treeComponentsList.addAll(this.containerComponentsList);
        for (int i = 0; i < this.containerComponentsList.size(); ++i) {
            NodeBank updateTree = MainFrame.NodeList.get(this.containerComponentsList.get(i));
            if (!updateTree.isContainer()) continue;
            this.treeComponentsList.addAll(updateTree.updateTreeComponents());
        }
        return this.treeComponentsList;
    }

    public ArrayList<Integer> getTreeComponents() {
        return this.treeComponentsList;
    }

    public int updateTreeSize() {
        this.treeSize = this.containerComponentsList.size();
        for (int i = 0; i < this.containerComponentsList.size(); ++i) {
            NodeBank updateTree = MainFrame.NodeList.get(this.containerComponentsList.get(i));
            if (!updateTree.isContainer()) continue;
            this.treeSize += updateTree.updateTreeSize();
        }
        return this.treeSize;
    }

    public int getTreeSize() {
        return this.treeSize;
    }

    public int updateTreeLevels() {
        if (this.containerComponentsList.size() > 0) {
            this.treeLevels = 1;
        }
        for (int i = 0; i < this.containerComponentsList.size(); ++i) {
            int tl;
            NodeBank updateTree = MainFrame.NodeList.get(this.containerComponentsList.get(i));
            if (!updateTree.isContainer() || (tl = updateTree.updateTreeLevels()) != this.treeLevels) continue;
            this.treeLevels += tl;
        }
        return this.treeLevels;
    }

    public int getTreeLevels() {
        return this.treeLevels;
    }

    public void updateNodeLevel() {
        String root = "assignRoot_meaninglessCode1245ty890xyz";
        String level = this.nestedAssignment;
        this.nodeLevel = 0;
        while (!level.equals(root)) {
            ++this.nodeLevel;
            int r = MainFrame.keyNodeArray.indexOf(level);
            level = MainFrame.NodeList.get(r).getNestedAssignment();
        }
    }

    public int getNodeLevel() {
        return this.nodeLevel;
    }

    public void assignTree() {
        if (this.isContainer) {
            for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                NodeBank cc = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                if (cc.isContainer()) {
                    cc.assignTree();
                    continue;
                }
                cc.assinarArvore();
            }
        }
    }

    private void assinarArvore() {
        if (this.isNestedNode && !this.isContainer) {
            Pattern pt = Pattern.compile("(.*)\\.\\$N[\\d]+");
            Matcher mt = pt.matcher(this.strNodeID);
            this.strNodeID = mt.matches() ? mt.group(1) + ".$" + this.nestedAssignment : this.strNodeID + ".$" + this.nestedAssignment;
            this.setDestaque(true);
        }
    }

    public void moveTree(float newX, float newY) {
        if (this.isContainer) {
            float dtx = newX - this.x;
            float dty = newY - this.y;
            this.x = newX;
            this.y = newY;
            for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                NodeBank cc = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                float locx = cc.getX() + dtx;
                float locy = cc.getY() + dty;
                cc.setNode(locx, locy);
                if (!cc.isContainer()) continue;
                cc.moveUpTree(dtx, dty);
            }
        }
    }

    private void moveUpTree(float dtx, float dty) {
        for (int i = 0; i < this.containerComponentsList.size(); ++i) {
            NodeBank cc = MainFrame.NodeList.get(this.containerComponentsList.get(i));
            float locx = cc.getX() + dtx;
            float locy = cc.getY() + dty;
            cc.setNode(locx, locy);
            if (!cc.isContainer()) continue;
            cc.moveUpTree(dtx, dty);
        }
    }

    public void setAsCopy() {
        this.isCopy = true;
    }

    public boolean isCopy() {
        return this.isCopy;
    }

    public int duplicateContainer(String nestedAssignment, boolean isToCopyCopies) {
        if (!this.isContainer) {
            return -1;
        }
        if (!isToCopyCopies && this.isCopy) {
            return -1;
        }
        int c = (Integer)MainFrame.keyNodeHash.get(this.getNodeID());
        this.thisNodeAccount = MainFrame.NodeList.get(c);
        MainFrame.originalMarcados.add(c);
        String newNestName = this.getUniqueNameContainer();
        MainFrame.NodeList.add(new NodeBank(newNestName, MainFrame.NodeList.size()));
        int refNewNest = MainFrame.NodeList.size() - 1;
        MainFrame.keyNodeHash.put(newNestName, new Integer(refNewNest));
        MainFrame.keyNodeArray.add(newNestName);
        MainFrame.newMarcados.add(refNewNest);
        this.newContainer = MainFrame.NodeList.get(refNewNest);
        this.transferNodeAttribs(this.thisNodeAccount, this.newContainer, nestedAssignment);
        for (int i = 0; i < this.getContainerComponents().size(); ++i) {
            this.component = MainFrame.NodeList.get(this.getContainerComponents().get(i));
            if (this.component.isContainer()) {
                this.component.duplicateContainer(newNestName, isToCopyCopies);
                continue;
            }
            int cc = (Integer)MainFrame.keyNodeHash.get(this.component.getNodeID());
            MainFrame.originalMarcados.add(cc);
            String copynode = this.getAssignedName(this.component.getNodeID(), newNestName);
            MainFrame.NodeList.add(new NodeBank(copynode, MainFrame.NodeList.size()));
            MainFrame.keyNodeHash.put(copynode, new Integer(MainFrame.NodeList.size() - 1));
            MainFrame.keyNodeArray.add(copynode);
            MainFrame.newMarcados.add(MainFrame.NodeList.size() - 1);
            this.nodeCopyAccount = MainFrame.NodeList.get(MainFrame.NodeList.size() - 1);
            this.transferNodeAttribs(this.component, this.nodeCopyAccount, newNestName);
        }
        return refNewNest;
    }

    private void transferNodeAttribs(NodeBank originalAccount, NodeBank copyAccount, String nestAssigment) {
        if (!originalAccount.isContainer()) {
            copyAccount.setAliases(originalAccount.getAliases());
        }
        copyAccount.setFont(originalAccount.getFont());
        copyAccount.setFontColor(originalAccount.getNodeFontColor());
        copyAccount.setFontSize(originalAccount.getFontSize());
        copyAccount.setFontX(originalAccount.getFontX());
        copyAccount.setFontY(originalAccount.getFontY());
        if (originalAccount.isContainer()) {
            copyAccount.setContainer(true);
            copyAccount.setContainerAnchored(originalAccount.isContainerAnchored());
            copyAccount.setContainerHided(originalAccount.isContainerHided());
            copyAccount.setContainerTransparent(originalAccount.isContainerTransparent());
        }
        copyAccount.setNodeNested(nestAssigment);
        if (originalAccount.isGroup()) {
            copyAccount.setAsGroup(true);
            copyAccount.setGroupCompNumber(originalAccount.getGroupCompNumber());
            copyAccount.setGroupComponents(originalAccount.getGroupComponets());
            copyAccount.setAsGroup(originalAccount.isGroup());
        }
        copyAccount.setNodeBend(originalAccount.getNodeBend());
        copyAccount.setNodeColor(originalAccount.getTrueNodeColor());
        copyAccount.setNodeGradient(originalAccount.isNodeGradient());
        copyAccount.setNodeLineColor(originalAccount.getNodeLineColor());
        copyAccount.setNodeLineWidth(originalAccount.getNodeLineWidth());
        copyAccount.setNodeShape(originalAccount.getNodeShape());
        copyAccount.setNodeLineType(originalAccount.getNodeLineType());
        copyAccount.setNodeSize(originalAccount.getNodeSize());
        copyAccount.setWeight(originalAccount.getNodeWeight());
        copyAccount.setNode(originalAccount.getX(), originalAccount.getY());
        copyAccount.setAsCopy();
    }

    public String getUniqueNameContainer() {
        int gn = 0;
        int tn = 0;
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            NodeBank nodeAccount = MainFrame.NodeList.get(i);
            if (!nodeAccount.isContainer()) continue;
            String testNumber = nodeAccount.getNodeID();
            testNumber = (String)testNumber.subSequence(1, testNumber.length());
            try {
                tn = Integer.parseInt(testNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (tn < gn) continue;
            gn = tn + 1;
        }
        String containerName = "N" + gn;
        while (true) {
            if (!MainFrame.keyNodeHash.containsKey(containerName)) {
                boolean flag = false;
                for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
                    NodeBank nodeAccount = MainFrame.NodeList.get(i);
                    boolean b = nodeAccount.getNodeID().contains(".$" + containerName);
                    if (!b) continue;
                    flag = true;
                }
                if (!flag) break;
            }
            containerName = "N" + ++gn;
        }
        return containerName;
    }

    private String getAssignedName(String node, String newNestName) {
        Pattern pt = Pattern.compile("(.*)\\.\\$N[\\d]+");
        Matcher mt = pt.matcher(node);
        node = mt.matches() ? mt.group(1) + ".$" + newNestName : node + ".$" + newNestName;
        return node;
    }

    public void setNodeWeight(double att) {
        this.nodeWeight = att;
        this.setDestaque(true);
    }

    public void setWeight(double att) {
        this.nodeWeight = att;
    }

    public double getNodeWeight() {
        return this.nodeWeight;
    }

    public void setNormWeight(double weight) {
        this.normalizedWeight = weight;
    }

    public double getNormWeight() {
        if (this.isContainer) {
            double ww = 0.0;
            int nc = this.containerComponentsList.size();
            if (nc == 0) {
                return 0.0;
            }
            for (int i = 0; i < nc; ++i) {
                NodeBank cc = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                ww += cc.getNormWeight();
            }
            return ww /= (double)this.containerComponentsList.size();
        }
        return this.normalizedWeight;
    }

    public void attToNodeSize(float target, float range) {
        float base = (1.0f - (range /= 100.0f)) * target;
        float projectAtt = (float)((double)base + (double)(target -= base) * this.normalizedWeight);
        this.setNodeSize(projectAtt);
    }

    public void attToNodeColor(Color target) {
        int r = (int)((double)target.getRed() + (255.0 - 255.0 * this.normalizedWeight));
        int g = (int)((double)target.getGreen() + (255.0 - 255.0 * this.normalizedWeight));
        int b = (int)((double)target.getBlue() + (255.0 - 255.0 * this.normalizedWeight));
        r = Math.min(r, 255);
        g = Math.min(g, 255);
        b = Math.min(b, 255);
        this.nodeColor = new Color(r, g, b);
        this.lineColor = target;
    }

    public void attToGradientColor(Color source, Color target) {
        Color sourceColor = source;
        Color targeColor = target;
        int sr = sourceColor.getRed();
        int sg = sourceColor.getGreen();
        int sb = sourceColor.getBlue();
        int tr = targeColor.getRed();
        int tg = targeColor.getGreen();
        int tb = targeColor.getBlue();
        int r = sr;
        int g = sg;
        int b = sb;
        if (sr < tr) {
            r = (int)((double)sr + (double)(tr - sr) * this.normalizedWeight);
            r = Math.min(r, tr);
        } else if (sr > tr) {
            r = (int)((double)sr - (double)(sr - tr) * this.normalizedWeight);
            r = Math.max(r, tr);
        }
        if (sg < tg) {
            g = (int)((double)sg + (double)(tg - sg) * this.normalizedWeight);
            g = Math.min(g, tg);
        } else if (sg > tg) {
            g = (int)((double)sg - (double)(sg - tg) * this.normalizedWeight);
            g = Math.max(g, tg);
        }
        if (sb < tb) {
            b = (int)((double)sb + (double)(tb - sb) * this.normalizedWeight);
            b = Math.min(b, tb);
        } else if (sb > tb) {
            b = (int)((double)sb - (double)(sb - tb) * this.normalizedWeight);
            b = Math.max(b, tb);
        }
        this.nodeColor = new Color(r, g, b);
        this.lineColor = new Color(r, g, b);
    }

    public void setFont(Font font) {
        this.font = font;
        this.fonteSize = font.getSize();
    }

    public void setFontSize(int size) {
        if (size < 0) {
            return;
        }
        this.fonteSize = size;
        this.font = new Font(this.font.getName(), this.font.getStyle(), this.fonteSize);
    }

    public void setAliases(String aliases) {
        this.aliases = aliases;
    }

    public void setFontX(float fontPositionX) {
        this.fontPositionX = fontPositionX;
    }

    public void setFontY(float fontPositionY) {
        this.fontPositionY = fontPositionY;
    }

    public void setLegendOn() {
        this.displayLegend = true;
    }

    public void setLegendOff() {
        this.displayLegend = false;
    }

    public boolean legendIsOn() {
        return this.displayLegend;
    }

    public void setNode(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setNodeToSave(float x, float y) {
        this.xToSave = x;
        this.yToSave = y;
    }

    public void setNode(float x, float y, float h, float w) {
        this.x = x;
        this.y = y;
        this.h = h;
        this.w = w;
        this.nodeSize = h / (this.h0 * (0.5f + this.nodeBend / 100.0f));
        this.nodeBend = (h - 0.5f * this.h0 * this.nodeSize) * 100.0f / (this.h0 * this.nodeSize);
    }

    public void setNodeSize(float size) {
        if (size < 0.0f) {
            return;
        }
        this.nodeSize = size;
        this.h = this.h0 * this.nodeSize * (0.5f + this.nodeBend / 100.0f);
        this.w = this.w0 * this.nodeSize * (1.0f + (0.5f - this.nodeBend / 100.0f));
    }

    public void setNodeSizeScale(float sizeFraction) {
        this.nodeSize *= sizeFraction;
        this.h = this.h0 * this.nodeSize * (0.5f + this.nodeBend / 100.0f);
        this.w = this.w0 * this.nodeSize * (1.0f + (0.5f - this.nodeBend / 100.0f));
    }

    public void setNodeBend(float bendPercentage) {
        if (bendPercentage < 0.0f || bendPercentage > 100.0f) {
            return;
        }
        this.nodeBend = bendPercentage;
        this.h = this.h0 * this.nodeSize * (0.5f + this.nodeBend / 100.0f);
        this.w = this.w0 * this.nodeSize * (1.0f + (0.5f - this.nodeBend / 100.0f));
    }

    public void setNodeBendScale(float bendFraction) {
        this.nodeBend *= bendFraction;
        this.h = this.h0 * this.nodeSize * (0.5f + this.nodeBend / 100.0f);
        this.w = this.w0 * this.nodeSize * (1.0f + (0.5f - this.nodeBend / 100.0f));
    }

    public void setNodeColor(Color nodeColor) {
        this.nodeColor = nodeColor;
    }

    public void setNodeGradient(boolean gradient) {
        this.nodeGradient = gradient;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public void setNodeShape(String type) {
        this.nodeShape = type;
    }

    public void setNodeLineType(String type) {
        boolean b = Pattern.matches("SOLID|DOTTED_SHORT|LONG_DASH|DOTTED", type);
        if (b) {
            this.lineType = type;
        }
    }

    public void setDestaque(boolean destaque) {
        this.destaque = destaque;
        if (this.isContainer) {
            if (destaque) {
                for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                    NodeBank destacarComponentes = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                    destacarComponentes.setDestaque(true);
                }
            } else {
                for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                    NodeBank destacarComponentes = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                    destacarComponentes.setDestaque(false);
                }
            }
        }
        if (!destaque && this.isContainer) {
            this.containertreemark = destaque;
        }
    }

    public void setDestaqueNeighbours(boolean destaque) {
        this.destaque = destaque;
        if (destaque) {
            for (int i = 0; i < this.partnerList.size(); ++i) {
                NodeBank destacarPartner = MainFrame.NodeList.get(this.partnerList.get(i));
                if (destacarPartner.getNodeID().equals(this.nestedAssignment)) continue;
                destacarPartner.setDestaque(true);
            }
        } else {
            for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                NodeBank destacarPartner = MainFrame.NodeList.get(this.partnerList.get(i));
                if (destacarPartner.getNodeID().equals(this.nestedAssignment)) continue;
                destacarPartner.setDestaque(false);
            }
        }
    }

    public void setDestaqueSimples(boolean destaque, boolean destacarNest) {
        this.destaque = destaque;
        if (this.isContainer) {
            this.containertreemark = destaque;
            for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                NodeBank destacarComponentes = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                if (destacarComponentes.isContainer()) {
                    destacarComponentes.setContainerTreeMark(destaque);
                    continue;
                }
                if (!destacarNest) continue;
                destacarComponentes.setDestaque(destaque);
            }
        }
    }

    public void setDragged(boolean b) {
        this.isDragged = b;
    }

    public boolean isDragged() {
        return this.isDragged;
    }

    public void setDestaque() {
        if (this.destaque) {
            this.destaque = false;
            if (this.isContainer) {
                for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                    NodeBank destacarComponentes = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                    destacarComponentes.setDestaque(false);
                }
            }
        } else {
            this.destaque = true;
            if (this.isContainer) {
                for (int i = 0; i < this.containerComponentsList.size(); ++i) {
                    NodeBank destacarComponentes = MainFrame.NodeList.get(this.containerComponentsList.get(i));
                    destacarComponentes.setDestaque(true);
                }
            }
        }
        if (!this.destaque && this.isContainer) {
            this.containertreemark = this.destaque;
        }
    }

    public void setNodeLineWidth(float lineWith) {
        this.lineWith = lineWith;
    }

    public void setLineWithScale(float withFraction) {
        this.lineWith *= withFraction;
    }

    public void setNodeLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void assignNetworkPartition(int partition) {
        this.setPartition(partition);
        for (int i = 0; i < this.partnerList.size(); ++i) {
            NodeBank assignedPartner = MainFrame.NodeList.get(this.partnerList.get(i));
            if (assignedPartner.getPartition() > 0 || assignedPartner.getNestedAssignment().equals(this.strNodeID) || assignedPartner.getNodeID().equals(this.nestedAssignment)) continue;
            assignedPartner.assignNetworkPartition(partition);
        }
    }

    private void setPartition(int partition) {
        this.networkPartition = partition;
    }

    public int getPartition() {
        return this.networkPartition;
    }

    public void resetPartition() {
        this.networkPartition = 0;
    }

    public Color getNodeColor() {
        Color cor = this.destaque ? this.corDestaque : this.nodeColor;
        return cor;
    }

    public Color getLineColor() {
        Color cor = this.destaque ? this.corDestaqueLinha : this.lineColor;
        return cor;
    }

    public boolean isNodeGradient() {
        return this.nodeGradient;
    }

    public Color getFontColor() {
        Color cor = this.destaque ? this.corDestaqueLinha : this.fontColor;
        return cor;
    }

    public float getFontX() {
        return this.fontPositionX;
    }

    public float getFontY() {
        return this.fontPositionY;
    }

    public Color getTrueNodeColor() {
        return this.nodeColor;
    }

    public Color getNodeLineColor() {
        return this.lineColor;
    }

    public Color getNodeFontColor() {
        return this.fontColor;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getXtoSave() {
        return this.xToSave;
    }

    public float getYtoSave() {
        return this.yToSave;
    }

    public float getW() {
        return this.w;
    }

    public float getH() {
        return this.h;
    }

    public String getNodeShape() {
        return this.nodeShape;
    }

    public String getNodeLineType() {
        return this.lineType;
    }

    public float getNodeSize() {
        return this.nodeSize;
    }

    public float getNodeBend() {
        return this.nodeBend;
    }

    public String getNodeID() {
        return this.strNodeID;
    }

    public String getAliases() {
        return this.aliases;
    }

    public Point2D getPoint() {
        this.ponto.setLocation(this.x, this.y);
        return this.ponto;
    }

    public float getNodeLineWidth() {
        return this.lineWith;
    }

    public int getFontSize() {
        return this.fonteSize;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean getDestaque() {
        if (this.isMockNode) {
            return false;
        }
        return this.destaque;
    }

    public double getDX() {
        return this.dx;
    }

    public void setDX(double dx) {
        this.dx = dx;
    }

    public double getDY() {
        return this.dy;
    }

    public void setDY(double dy) {
        this.dy = dy;
    }

    public double getVeloxy() {
        this.nveloxy = Math.max(1.0, this.nveloxy);
        this.veloxy = Math.max(1.0, this.veloxy / this.nveloxy);
        return this.veloxy;
    }

    public void addVeloxy(double vlx) {
        this.veloxy += vlx;
        this.nveloxy += 1.0;
    }

    public void resetVeloxy() {
        this.veloxy = 0.0;
        this.nveloxy = 0.0;
    }

    public void resetRelax() {
        this.veloxy = 0.0;
        this.nveloxy = 0.0;
        this.dy = 0.0;
        this.dx = 0.0;
    }

    public void countVirtualEdge() {
        ++this.nVirtualAssociations;
    }

    public int getVirtualEdgeCount() {
        return this.nVirtualAssociations;
    }

    public void resetVirtualEdgeCount() {
        this.nVirtualAssociations = 0;
    }

    public void loadBuffer() {
        this.bufferX = this.x;
        this.bufferY = this.y;
    }

    public float getBufferX() {
        return this.bufferX;
    }

    public float getBufferY() {
        return this.bufferY;
    }

    public void setPairwiseOn() {
        this.isUnderPairwise = true;
    }

    public void setPairwiseOff() {
        this.isUnderPairwise = false;
    }

    public boolean isUnderPairwise() {
        return this.isUnderPairwise;
    }

    private double getContainerSize(ArrayList<Integer> components) {
        int ncc = components.size();
        if (ncc == 1) {
            int nestedNode = components.get(0);
            NodeBank nodeAccount = MainFrame.NodeList.get(nestedNode);
            return nodeAccount.getNodeSize() * 2.0f;
        }
        if (ncc == 0) {
            return (double)this.getNodeSize() * 1.2;
        }
        Rectangle2D.Double rec = new Rectangle2D.Double();
        boolean flagMove = false;
        for (int i = 0; i < components.size(); ++i) {
            int nestedNode = components.get(i);
            NodeBank nodeAccount = MainFrame.NodeList.get(nestedNode);
            if (!flagMove) {
                flagMove = true;
                rec = nodeAccount.getRectangle();
                continue;
            }
            rec.add(nodeAccount.getRectangle());
        }
        double estimatedContainerSize = (rec.getHeight() + rec.getWidth()) / 2.0 * Math.sqrt(2.0);
        double escalaNodo = 20.0 * (MainFrame.getZoom() * this.relativeSize);
        return estimatedContainerSize / escalaNodo;
    }

    public Rectangle2D.Double getRectangle() {
        double ww = (double)this.w * MainFrame.getZoom() * this.relativeSize;
        double hh = (double)this.h * MainFrame.getZoom() * this.relativeSize;
        Rectangle2D.Double node = new Rectangle2D.Double(this.x, this.y, ww, hh);
        return node;
    }

    public void setAsMock() {
        this.isMockNode = true;
    }

    public boolean isMock() {
        return this.isMockNode;
    }
}

