### R code from vignette source 'HCsnip.Rnw'

###################################################
### code chunk number 1: chunk1
###################################################
library(HCsnip)
data(BullingerLeukemia)
names(BullingerLeukemia)


###################################################
### code chunk number 2: chunk2
###################################################
library(HCsnip)
data(TcgaGBM)
names(TcgaGBM)


###################################################
### code chunk number 3: chunk3
###################################################
data(BullingerLeukemia)
em <- BullingerLeukemia[["em"]]
cl <- HCsnipper(em[, 1:60], minclus = 5)
## To check returned partitions size
table(apply(cl[["partitions"]], 1, function(x) length(unique(x))))


###################################################
### code chunk number 4: chunk4
###################################################
data(BullingerLeukemia)
em <- BullingerLeukemia[["em"]]
cl <- HCsnipper(em[, 1:60], minclus = 5)
m <- apply(cl[["partitions"]], 1, function(x) measure(parti = x, 
                        dis = 1 - cor(em[, 1:60]))) 


###################################################
### code chunk number 5: chunk5
###################################################
data(BullingerLeukemia)
em <- BullingerLeukemia[["em"]]
st <- BullingerLeukemia[["surv.time"]]
event <- BullingerLeukemia[["status"]]
cl <- HCsnipper(em[, 1:60], min = 5)
bic <- apply(cl[["partitions"]], 1, function(x) surv_measure(x, 
                     st[1:60], event[1:60]))


###################################################
### code chunk number 6: chunk6
###################################################
data(BullingerLeukemia)
em <- BullingerLeukemia[["em"]]
st <- BullingerLeukemia[["surv.time"]]
event <- BullingerLeukemia[["status"]]
cl <- HCsnipper(em[, 1:60], min = 5)
m <- apply(cl[["partitions"]], 1, function(x) measure(parti = x, dis = 1-cor(em[, 1:60]))) 
s <- apply(cl[["partitions"]], 1, function(x) surv_measure(x, st[1:60], event[1:60]))
result <- perm_test(cl[["partitions"]], st[1:60], event[1:60], score1 = s, score2 = m, 
                       nperm = 10) 


###################################################
### code chunk number 7: chunk7
###################################################
data(TcgaGBM)
em <- TcgaGBM[["em"]]
drugs <- TcgaGBM[["drugs"]]
cl <- rep(1, ncol(em))
cl[drugs == "Temodar"] <- 2
H <- EnvioPlot(X = em, parti = cl, names = c("Avastin", "Temodar"), 
             col = c("blue", "red"))


###################################################
### code chunk number 8: chunk8
###################################################
data(BullingerLeukemia)
em <- BullingerLeukemia[["em"]]
st <-  BullingerLeukemia[["surv.time"]]
event <- BullingerLeukemia[["status"]]
cl <- HCsnipper(em[, 1:60], min = 5)
par(mfrow = c(1, 2))
result <- cluster_pred(X = em[, 1:100], partition = cl[["partitions"]][1, ], 
              surv.time = st[1:60], status = event[1:60], te.index = 61:100,
              te.surv.time = st[61:100], te.status = event[61:100], plot.it =TRUE)
H <- EnvioPlot(X = em[,61:100], parti = result[["St"]][, 2])              


###################################################
### code chunk number 9: chunk9
###################################################
data(BullingerLeukemia)
em <- BullingerLeukemia[["em"]]
st <-  BullingerLeukemia[["surv.time"]]
event <- BullingerLeukemia[["status"]]
cl <- HCsnipper(em[, 1:60], min=5)
pred <- cluster_pred(X = em[, 1:100], partition = cl[["partitions"]][1, ], 
              surv.time = st[1:60], status = event[1:60], te.index = 61:100)
Err <- RSF_eval(cl[["partitions"]][1, ], st[1:60], 
              event[1:60], pred, st[61:100], event[61:100])


###################################################
### code chunk number 10: chunk10 (eval = FALSE)
###################################################
## data(TcgaGBM)
## id1 <- which(TcgaGBM[["drugs"]] == "Avastin")
## id2 <- which(TcgaGBM[["drugs"]] == "Temodar") 
## em <- TcgaGBM[["em"]]
## st <-  TcgaGBM[["surv.time"]]
## event <- TcgaGBM[["status"]]
## result <- TwoHC_assign(X = em[ ,c(id1[1:50], id2[1:50])], index1 = 1:50, 
##                 index2 = 51:100, new.X = em[, c(id1[51:60], id2[51:60])], 
##                 minclus = 4, surv.time = st[c(id1[1:50], id2[1:50])], 
##                 status = event[c(id1[1:50], id2[1:50])])  


###################################################
### code chunk number 11: chunk11 (eval = FALSE)
###################################################
## data(TcgaGBM)
## id1 <- which(TcgaGBM[["drugs"]] == "Avastin")
## id2 <- which(TcgaGBM[["drugs"]] == "Temodar") 
## em <- TcgaGBM[["em"]]
## st <-  TcgaGBM[["surv.time"]]
## event <- TcgaGBM[["status"]]
## twoHC <- TwoHC_assign(X = em[ ,c(id1[1:50], id2[1:50])], index1 = 1:50, 
##                   index2 = 51:100, new.X = em[, c(id1[51:60], id2[51:60])], 
##                   minclus = 4, surv.time = st[c(id1[1:50], id2[1:50])], 
##                   status = event[c(id1[1:50], id2[1:50])])  
## result <- TwoHC_perm(twoHC, nperm = 100)


