/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class TestFrame
extends JFrame {
    private JMenuBar menuBar;
    private JPanel topPanel;

    protected TestFrame() {
        this.setTitle(this.createTitle());
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.menuBar = this.createMenuBar();
        if (this.menuBar != null) {
            this.topPanel.add((Component)this.menuBar, "North");
            this.addToMenuBar(this.menuBar);
        }
        this.topPanel.add((Component)this.createComponent(), "Center");
        this.getContentPane().add(this.topPanel);
        this.menuBar.add(this.createLookAndFeelMenu());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TestFrame.this.quit();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    protected JMenu createLookAndFeelMenu() {
        JMenu look = new JMenu("Look and Feel");
        ButtonGroup group = new ButtonGroup();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < info.length; ++i) {
            JRadioButtonMenuItem radio = new JRadioButtonMenuItem(info[i].getName());
            radio.setActionCommand(info[i].getClassName());
            radio.setSelected(info[i].getName().equals(UIManager.getLookAndFeel().getName()));
            look.add(radio);
            group.add(radio);
            radio.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        UIManager.setLookAndFeel(e.getActionCommand());
                        SwingUtilities.updateComponentTreeUI(TestFrame.this.topPanel);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return look;
    }

    protected JMenuBar createMenuBar() {
        return new JMenuBar();
    }

    protected void addToMenuBar(JMenuBar menuBar) {
    }

    protected abstract JComponent createComponent();

    protected String createTitle() {
        return "Test Frame";
    }

    public void quit() {
        int n = JOptionPane.showConfirmDialog(this, "Do you really want to quit?", "Confirm Quit", 0);
        if (n == 0) {
            System.exit(0);
        }
    }
}

