### R code from vignette source 'DASiR.Rnw'

###################################################
### code chunk number 1: library
###################################################
library(DASiR)
?DASiR


###################################################
### code chunk number 2: setget
###################################################
setDasServer(server="http://genome.ucsc.edu/cgi-bin/das")
getDasServer()


###################################################
### code chunk number 3: sources
###################################################
#sources = getDasSource() #This will fail for UCSC (but no for ENSEMBL)
sources = getDasDsn() #This will fail for ENSEMBL (but no for UCSC)
head(sources)


###################################################
### code chunk number 4: entries
###################################################
source = "sacCer3"
entries = getDasEntries(source, as.GRanges=TRUE)
head(entries)


###################################################
### code chunk number 5: types
###################################################
types = getDasTypes(source)
head(types)


###################################################
### code chunk number 6: getDasFeature
###################################################
ranges=entries[c(1,2)]
types=c("sgdGene","mrna")
  
features = getDasFeature(source, ranges, types)
head(features)


###################################################
### code chunk number 7: getDasSequence
###################################################
#Now we will retrieve sequences from VEGA server
setDasServer("http://vega.sanger.ac.uk/das")
source = "Homo_sapiens.VEGA51.reference"
ranges = GRanges(c("1","2"), IRanges(start=10e6, width=1000))

#Returning character vector, we only ask 50 first bases in the range
sequences = getDasSequence(source, resize(ranges, fix="start", 50))        

print(sequences)


###################################################
### code chunk number 8: getDasSequence2
###################################################
#Now we specify we want a AAStringSet (Biostring class for AminoAcids strings)
#and query for the whole sequence length
sequences = getDasSequence(source, ranges, class="AAStringSet")
print(sequences)


###################################################
### code chunk number 9: getDasStructure
###################################################
#On 2013-03-05 there are 2 structure servers in dasregistry.org...
setDasServer(server="http://das.sanger.ac.uk/das")       

#Get the sources with "structure" capability...
sources = getDasSource()
sources[grep("structure", sources$capabilities),]
source="structure" #...which name is also "structure"

query="1HCK" #PDB code
  
structure=getDasStructure(source,query)
  
head(structure)


###################################################
### code chunk number 10: getPlotFeature
###################################################
#Let's retrieve some genes from UCSC Genome Browser DAS Server now
setDasServer(server="http://genome.ucsc.edu/cgi-bin/das")

#Official yeast genes and other annotated features in the range I:22k-30k
source = "sacCer3" #Saccharomices Cerevisiae
range = GRanges(c("I"), IRanges(start=22000, end=30000))
type  = c("sgdGene", "sgdOther") #This is also the name of the UCSC tracks
	
features = getDasFeature(source, range, type)
#Only the main columns
head(features[,c("id", "label", "type", "start", "end")])

plotFeatures(features, box.height=10, box.sep=15, pos.label="top", xlim=c(22000,30000))


###################################################
### code chunk number 11: plotFeature
###################################################
par(mar=c(6,3,0,3), cex=0.75)
plotFeatures(features, box.height=10, box.sep=15, pos.label="top", xlim=c(22000,30000))


###################################################
### code chunk number 12: plotFeature
###################################################
par(mar=c(6,3,0,3), cex=0.75)
plotFeatures(features, box.height=10, box.sep=15, pos.label="top", xlim=c(22000,30000))


