### R code from vignette source 'Agi4x44PreProcess.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: Agi4x44PreProcess.Rnw:60-61
###################################################
library("hgug4112a.db")


###################################################
### code chunk number 2: data
###################################################
library("Agi4x44PreProcess")
data(targets)
targets


###################################################
### code chunk number 3: data
###################################################
data(dd) 
class(dd)
dim(dd)


###################################################
### code chunk number 4: Agi4x44PreProcess.Rnw:187-188
###################################################
names(dd)


###################################################
### code chunk number 5: BoxPlot1
###################################################
BoxPlot(log2(dd$R),"ProcessedSignal", "red",
xlab="Samples", ylab="expression")


###################################################
### code chunk number 6: plotDensity1
###################################################
plotDensity(log2(dd$R),"ProcessedSignal")


###################################################
### code chunk number 7: BoxPlot2
###################################################
BoxPlot(log2(dd$G),"MeanSignal", "green",
xlab="Samples", ylab="expression")


###################################################
### code chunk number 8: plotDensity2
###################################################
plotDensity(log2(dd$G),"MeanSignal")


###################################################
### code chunk number 9: BoxPlot3
###################################################
BoxPlot(log2(dd$Gb),"BGUsed", "orange",
xlab="Samples", ylab="expression")


###################################################
### code chunk number 10: BoxPlot4
###################################################
BoxPlot(log2(dd$Rb),"BGMedianSignal", "blue",
xlab="Samples", ylab="expression")


###################################################
### code chunk number 11: CV.rep.probes
###################################################
CV.rep.probes(dd,"hgug4112a.db",
               	foreground="MeanSignal", raw.data=TRUE,
		writeR=FALSE, targets)


###################################################
### code chunk number 12: genes.rpt.agi
###################################################
genes.rpt.agi(dd,"hgug4112a.db",raw.data=TRUE,
               WRITE.html=FALSE,REPORT=FALSE)


###################################################
### code chunk number 13: BGandNorm
###################################################
ddNORM=BGandNorm(dd,BGmethod="half",NORMmethod="quantile",
                 foreground="MeanSignal",background="BGMedianSignal",
                 offset=50,makePLOTpre=FALSE,makePLOTpost=FALSE)


###################################################
### code chunk number 14: filter.probes
###################################################
ddFILT=filter.probes(ddNORM,
                control=TRUE,
                wellaboveBG=TRUE,
                isfound=TRUE,
                wellaboveNEG=TRUE,
                sat=TRUE,
                PopnOL=TRUE,
                NonUnifOL=T,
                nas=TRUE,
                limWellAbove=75,
                limISF=75,
                limNEG=75,
                limSAT=75,
                limPopnOL=75,
                limNonUnifOL=75,
                limNAS=100,
                makePLOT=F,annotation.package="hgug4112a.db",flag.counts=T,targets)


###################################################
### code chunk number 15: Agi4x44PreProcess.Rnw:612-613
###################################################
dim(ddFILT)


###################################################
### code chunk number 16: summarize.probe
###################################################
ddPROC=summarize.probe(ddFILT, makePLOT=FALSE, targets)


###################################################
### code chunk number 17: build.eset
###################################################
esetPROC=build.eset(ddPROC, targets, makePLOT=FALSE,
                annotation.package="hgug4112a.db")


###################################################
### code chunk number 18: BoxPlot (eval = FALSE)
###################################################
## BoxPlot(log2(dd$G),"MeanSignal","green",
## xlab="Samples",ylab="expression")


###################################################
### code chunk number 19: boxplotNegCtrl
###################################################
boxplotNegCtrl(dd,Log2=FALSE, channel="G")


###################################################
### code chunk number 20: plotDensity (eval = FALSE)
###################################################
## plotDensity(log2(dd$G),"Density Plot example")


###################################################
### code chunk number 21: MVAplotMEDctrl (eval = FALSE)
###################################################
## 
## par(mfrow=c(2,2),ask=TRUE)	
## MVAplotMEDctrl(dd,"MVA example",channel="G")


###################################################
### code chunk number 22: MVAplotMED (eval = FALSE)
###################################################
## par(mfrow=c(2,2))
## MVAplotMED(dd$G,"red","MVA example")


###################################################
### code chunk number 23: RLE
###################################################
par(mfrow=c(1,1))	
RLE(log2(dd$G),"RLE example ","orange")



###################################################
### code chunk number 24: HeatMap
###################################################
HeatMap(exprs(esetPROC),size=100,"100 High Var genes")


###################################################
### code chunk number 25: hierclus
###################################################

data(targets)
GErep=targets$Gerep 
hierclus(exprs(esetPROC),GErep,methdis="euclidean",
        methclu="complete",sel=FALSE,size = 100)



###################################################
### code chunk number 26: PCAplot (eval = FALSE)
###################################################
## 
## data(targets)
## PCAplot(esetPROC,targets)


