### R code from vignette source 'inSilicoMerging.Rnw'

###################################################
### code chunk number 1: example_1
###################################################
library(inSilicoDb)
eset1 = getDataset("GSE19804", "GPL570", norm="FRMA", genes=TRUE);
eset2 = getDataset("GSE10072", "GPL96",  norm="FRMA", genes=TRUE);
esets = list(eset1,eset2);


###################################################
### code chunk number 2: example_2
###################################################
table(pData(eset1)[,"Disease"]);
table(pData(eset2)[,"Disease"]);


###################################################
### code chunk number 3: example_3
###################################################
library(inSilicoMerging);
eset_NONE = merge(esets, method="NONE");


###################################################
### code chunk number 4: example_4
###################################################
plotMDS(eset_NONE, 
        targetAnnot="Disease",
        batchAnnot="Study",
        main="NONE (No Transformation)");


###################################################
### code chunk number 5: example_5
###################################################
eset_COMBAT = merge(esets, method="COMBAT");
plotMDS(eset_COMBAT,
        targetAnnot="Disease",
        batchAnnot="Study",
        main="COMBAT");


###################################################
### code chunk number 6: example_6a (eval = FALSE)
###################################################
## par(mfrow=c(1,2))
## select = sample(1:ncol(eset_NONE),25);
## plotDendrogram(eset_NONE[,select], 
##                batchAnnot="Study", 
##                legend=FALSE, 
##                main="NONE");
## plotDendrogram(eset_COMBAT[,select], 
##                batchAnnot="Study", 
##                legend=FALSE, 
##                main="COMBAT");


###################################################
### code chunk number 7: example_6b
###################################################
ofile = "example_6.pdf";
pdf(file=ofile, paper="special", width=10, height=6);

par(mfrow=c(1,2))
select = sample(1:ncol(eset_NONE),25);
plotDendrogram(eset_NONE[,select], batchAnnot="Study", legend=FALSE, main="NONE");
plotDendrogram(eset_COMBAT[,select], batchAnnot="Study", legend=FALSE, main="COMBAT");


for(i in 1:1) { dev.off(); }
cat("\\begin{center}\\includegraphics[width=\\textwidth]{", ofile, "}\\end{center}\n\n", sep="");


###################################################
### code chunk number 8: example_7a (eval = FALSE)
###################################################
## par(mfrow=c(1,2))
## select = sample(1:ncol(eset_NONE),25);
## plotRLE(eset_NONE[,select], 
##         batchAnnot="Study", 
##         legend=FALSE, 
##         main="NONE");
## plotRLE(eset_COMBAT[,select], 
##         batchAnnot="Study", 
##         legend=FALSE, 
##         main="COMBAT");


###################################################
### code chunk number 9: example_7b
###################################################
ofile = "example_7.pdf";
pdf(file=ofile, paper="special", width=10, height=6);

par(mfrow=c(1,2))
select = sample(1:ncol(eset_NONE),25);
plotRLE(eset_NONE[,select], batchAnnot ="Study", legend=FALSE, main="NONE");
plotRLE(eset_COMBAT[,select], batchAnnot ="Study", legend=FALSE, main="COMBAT");

for(i in 1:1) { dev.off(); }
cat("\\begin{center}\\includegraphics[width=\\textwidth]{", ofile, "}\\end{center}\n\n", sep="");


###################################################
### code chunk number 10: example_8a (eval = FALSE)
###################################################
## eset_BMC = merge(esets, method="BMC");
## eset_DWD = merge(esets, method="DWD");
## 
## gene = "MYL4";
## par(mfrow=c(2,2));
## plotGeneWiseBoxPlot(eset_NONE, targetAnnot ="Disease", batchAnnot ="Study", 
##                     gene=gene, legend=TRUE, main="NONE");
## plotGeneWiseBoxPlot(eset_COMBAT, targetAnnot ="Disease", batchAnnot ="Study", 
##                     gene=gene, legend=FALSE, main="COMBAT");
## plotGeneWiseBoxPlot(eset_BMC, targetAnnot ="Disease", batchAnnot ="Study", 
##                     gene=gene, legend=FALSE, main="BMC");
## plotGeneWiseBoxPlot(eset_DWD, targetAnnot ="Disease", batchAnnot ="Study", 
##                     gene=gene, legend=FALSE, main="DWD");


###################################################
### code chunk number 11: example_8b
###################################################
eset_BMC = merge(esets, method="BMC");
eset_DWD = merge(esets, method="DWD");

ofile = "example_8.pdf";
pdf(file=ofile, paper="special", width=8, height=6);

gene = "MYL4";
par(mfrow=c(2,2));
plotGeneWiseBoxPlot(eset_NONE, targetAnnot ="Disease", batchAnnot ="Study", 
                                          gene=gene, legend=TRUE, main="NONE");
plotGeneWiseBoxPlot(eset_COMBAT, targetAnnot ="Disease", batchAnnot ="Study", 
                                          gene=gene, legend=FALSE, main="COMBAT");
plotGeneWiseBoxPlot(eset_BMC, targetAnnot ="Disease", batchAnnot ="Study", 
                                          gene=gene, legend=FALSE, main="BMC");
plotGeneWiseBoxPlot(eset_DWD, targetAnnot ="Disease", batchAnnot ="Study", 
                                          gene=gene, legend=FALSE, main="DWD");

for(i in 1:1) { dev.off(); }
cat("\\begin{center}\\includegraphics[width=\\textwidth]{", ofile, "}\\end{center}\n\n", sep="");


###################################################
### code chunk number 12: example_9a (eval = FALSE)
###################################################
## gene = "MYL4";
## par(mfrow=c(2,2));
## plotGeneWiseDensity(eset_NONE, batchAnnot ="Study", 
##                                           gene=gene, legend=TRUE, main="NONE");
## plotGeneWiseDensity(eset_COMBAT, batchAnnot ="Study", 
##                                           gene=gene, legend=FALSE, main="COMBAT");
## plotGeneWiseDensity(eset_BMC, batchAnnot ="Study", 
##                                           gene=gene, legend=FALSE, main="BMC");
## plotGeneWiseDensity(eset_DWD, batchAnnot ="Study", 
##                                           gene=gene, legend=FALSE, main="DWD");


###################################################
### code chunk number 13: example_9b
###################################################
ofile = "example_9.pdf";
pdf(file=ofile, paper="special", width=8, height=6);

gene = "MYL4";
par(mfrow=c(2,2));
plotGeneWiseDensity(eset_NONE, batchAnnot ="Study", 
                                          gene=gene, legend=TRUE, main="NONE");
plotGeneWiseDensity(eset_COMBAT, batchAnnot ="Study", 
                                          gene=gene, legend=FALSE, main="COMBAT");
plotGeneWiseDensity(eset_BMC, batchAnnot ="Study", 
                                           gene=gene, legend=FALSE, main="BMC");
plotGeneWiseDensity(eset_DWD, batchAnnot ="Study", 
                                          gene=gene, legend=FALSE, main="DWD");

for(i in 1:1) { dev.off(); }
cat("\\begin{center}\\includegraphics[width=\\textwidth]{", ofile, "}\\end{center}\n\n", sep="");


###################################################
### code chunk number 14: inSilicoMerging.Rnw:308-309
###################################################
sessionInfo()


