### R code from vignette source 'flowWorkspace.Rnw'

###################################################
### code chunk number 1: loadlib
###################################################
library(flowWorkspace)


###################################################
### code chunk number 2: findxml
###################################################
d<-system.file("extdata",package="flowWorkspaceData");
wsfile<-list.files(d,pattern="A2004Analysis.xml",full=T)


###################################################
### code chunk number 3: openws
###################################################
ws<-openWorkspace(wsfile)
summary(ws)


###################################################
### code chunk number 4: parsews
###################################################
G<-parseWorkspace(ws,name=1,path=ws@path,isNcdf=FALSE,cleanup=FALSE,keep.indices=TRUE); #import the first group
#Lots of output here suppressed for the vignette.


###################################################
### code chunk number 5: summary
###################################################
G


###################################################
### code chunk number 6: execute (eval = FALSE)
###################################################
## G<-lapply(G,function(x)execute(x))


###################################################
### code chunk number 7: plotGH
###################################################
require(Rgraphviz)
plot(G[[1]])


###################################################
### code chunk number 8: getNodes
###################################################
getNodes(G[[1]])


###################################################
### code chunk number 9: getGate
###################################################
getGate(G[[1]],getNodes(G[[1]])[3])


###################################################
### code chunk number 10: getDims
###################################################
getDimensions(G[[1]],getNodes(G[[1]])[3])


###################################################
### code chunk number 11: getBound
###################################################
getBoundaries(G[[1]],getNodes(G[[1]])[3])


###################################################
### code chunk number 12: getProp
###################################################
getProp(G[[1]],getNodes(G[[1]])[3])


###################################################
### code chunk number 13: getStats
###################################################
getPopStats(G[[1]])


###################################################
### code chunk number 14: plotPCV
###################################################
print(plotPopCV(G[[2]]))


###################################################
### code chunk number 15: plotGate
###################################################
print(plotGate(G[[1]],getNodes(G[[1]])[6],lwd=2,cex=2))


###################################################
### code chunk number 16: annotate
###################################################
d<-data.frame(sample=factor(c("sample 1", "sample 2")),treatment=factor(c("sample","control")) )
G@metadata<-new("AnnotatedDataFrame",data=d)
pData(G);


###################################################
### code chunk number 17: getData
###################################################
getData(G[[1]],getNodes(G[[1]])[3]);


###################################################
### code chunk number 18: getInd
###################################################
getIndices(G[[1]],getNodes(G[[1]])[3])


###################################################
### code chunk number 19: getCMAT
###################################################
C<-getCompensationMatrices(ws);
C


###################################################
### code chunk number 20: getTrans
###################################################
T<-getTransformations(ws)
names(T)
names(T[[1]])
T[[1]][[1]]


###################################################
### code chunk number 21: tnames
###################################################
A<-names(T)
B<-names(T[[1]])


###################################################
### code chunk number 22: getsamples
###################################################
getSamples(ws);


###################################################
### code chunk number 23: getgroups
###################################################
getSampleGroups(ws)


###################################################
### code chunk number 24: convert2flowcore
###################################################
wfs<-flowWorkspace2flowCore(G,path=ws@path);
wfs



###################################################
### code chunk number 25: plotworkflow
###################################################
plotWf(wfs[[1]])


###################################################
### code chunk number 26: closews
###################################################
closeWorkspace(ws);
ws


