### R code from vignette source 'VegaMC.Rnw'

###################################################
### code chunk number 1: library_VegaMC
###################################################
library(VegaMC)


###################################################
### code chunk number 2: copy_dataset
###################################################
file.copy(system.file("example/breast_Affy500K.txt",
    package="VegaMC"),".")


###################################################
### code chunk number 3: runVegaMC_breast
###################################################
results <-
vegaMC("breast_Affy500K.txt",
	output_file_name="breast.analysis",
	beta=1,	min_region_bp_size=2000, bs=5000,
	html=FALSE, getGenes=FALSE)


###################################################
### code chunk number 4: colnames_results
###################################################
colnames(results)


###################################################
### code chunk number 5: Create_BAFSet
###################################################
data(genoset)
baf.ds = BAFSet(locData=locData.rd, lrr=fake.lrr, baf=fake.baf,
                  pData=fake.pData, annotation="SNP6",
                  universe="hg19" )


###################################################
### code chunk number 6: runVegaMC_BAFSet
###################################################
genoset.results <- vegaMC(baf.ds,
                output_file_name="genoset.analysis.default",
                html=FALSE, getGenes=FALSE)


###################################################
### code chunk number 7: Create_CNSet
###################################################
cn.ds = CNSet(locData=locData.rd, cn=fake.lrr, pData=fake.pData,
                annotation="SNP6", universe="hg19")


###################################################
### code chunk number 8: runVegaMC_CNSet
###################################################
genoset.results <- vegaMC(cn.ds,
                output_file_name="genoset.analysis.default",
                html=FALSE, getGenes=FALSE)


