### R code from vignette source 'basicReportingTools.Rnw'

###################################################
### code chunk number 1: makeBasicDataFrame
###################################################

my.df <- data.frame(EGID = c("103", "104", "105", "106", "107"),
                    RPKM = c(4, 5, 3, 100, 75),
                    DE = c("Yes", "Yes", "No", "No", "No"))
my.df


###################################################
### code chunk number 2: makeCSVFile (eval = FALSE)
###################################################
## library(ReportingTools)
## 
## csvFile <- CSVFile(shortName = "my_csv_file", 
##     reportDirectory = "./reports/")
## publish(my.df, csvFile)


###################################################
### code chunk number 3: basicHTMLReport (eval = FALSE)
###################################################
## htmlRep <- HTMLReport(shortName = "my_html_file",
##     reportDirectory = "./reports/")
## publish(my.df, htmlRep)
## finish(htmlRep)


###################################################
### code chunk number 4: reportingTwoTypes (eval = FALSE)
###################################################
## csvFile2 <- CSVFile(shortName = "my_csv_file2", 
##     reportDirectory = "./reports/")
## htmlRep2 <- HTMLReport(shortName = 'my_html_file2',
##     reportDirectory = "./reports/")
## publish(my.df, list(csvFile2, htmlRep2))
## finish(htmlRep2)


###################################################
### code chunk number 5: AddTextPlot (eval = FALSE)
###################################################
## png(filename="reports/barplot.png")
## barplot(my.df$RPKM, names.arg=my.df$EGID, xlab="EGID", 
## 	ylab="RPKM", main="Bar plot of RPKMs", col="blue")
## dev.off()
## 
## library(hwriter)
## htmlRep3 <- HTMLReport(shortName = "my_html_file3",
##     reportDirectory = "./reports/")
## hwrite("Bar chart of results", p=page(htmlRep3), heading=2)
## himg<-hwriteImage("barplot.png", link="barplot.png")
## hwrite(himg, page(htmlRep3), br=TRUE)
## hwrite("Results Table", p=page(htmlRep3), heading=2)
## publish(my.df, htmlRep3)
## finish(htmlRep3)


###################################################
### code chunk number 6: styledCss (eval = FALSE)
###################################################
## css.file <- system.file('extdata/table.css', package='ReportingTools')
## htmlRep4 <- HTMLReport(shortName = 'my_html_file4',
##     reportDirectory = "./reports/", link.css=css.file)
## publish(my.df, htmlRep4)
## finish(htmlRep4)


