### R code from vignette source 'RGalaxy-vignette.Rnw'

###################################################
### code chunk number 1: exampleFunction
###################################################
library(RGalaxy)
show(functionToGalaxify)


###################################################
### code chunk number 2: hidden-setup
###################################################
galaxyHome <- getwd()
toolDir <- "RGalaxy_test_tool"
funcName <- "functionToGalaxify"

#dir.create(galaxyHome, recursive=TRUE, showWarnings=FALSE)
file.copy(system.file("galaxy", "tool_conf.xml", package="RGalaxy"),
    file.path(galaxyHome, "tool_conf.xml"), overwrite=FALSE)



###################################################
### code chunk number 3: galaxy-function
###################################################
galaxy(functionToGalaxify,
    manpage="functionToGalaxify",
    version="0.99.0",
    name="Add", 
    package="RGalaxy",
    galaxyConfig=GalaxyConfig(getwd(), "mytool", "Test Section",
        "testSectionId")
    )


###################################################
### code chunk number 4: datasets
###################################################
system.file("extdata", "a.tsv", package="RGalaxy")
system.file("extdata", "b.tsv", package="RGalaxy")


###################################################
### code chunk number 5: useful-example
###################################################
probeLookup <- function(probe_ids=character(),
    outputfile=GalaxyOutput("probeLookup", "csv"))
{
    ## probe_ids can be something like "1002_f_at 1003_s_at"
    library(hgu95av2.db)
    ids <- strsplit(probe_ids, " ")[[1]]
    results <- select(hgu95av2.db, keys=ids, cols=c("SYMBOL","PFAM"),
        keytype="PROBEID")
    write.csv(results, file=outputfile)
}


###################################################
### code chunk number 6: lookup-probe-lookup
###################################################
system.file("extdata", "probeLookup.Rd", package="RGalaxy")


###################################################
### code chunk number 7: expose-probe-function
###################################################
galaxy(probeLookup, 
    version="0.0.1",
    manpage=system.file("extdata", "probeLookup.Rd", package="RGalaxy"),
    galaxyConfig=GalaxyConfig(galaxyHome, "probeTool", "Test Section",
        "testSectionId")
    )


