/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cytoscape.equations.EqnParser;
import org.cytoscape.equations.Function;
import org.cytoscape.equations.Token;
import org.cytoscape.equations.Tokeniser;
import org.cytoscape.equations.parse_tree.BinOpNode;
import org.cytoscape.equations.parse_tree.BooleanConstantNode;
import org.cytoscape.equations.parse_tree.FConvNode;
import org.cytoscape.equations.parse_tree.FloatConstantNode;
import org.cytoscape.equations.parse_tree.FuncCallNode;
import org.cytoscape.equations.parse_tree.IdentNode;
import org.cytoscape.equations.parse_tree.Node;
import org.cytoscape.equations.parse_tree.SConvNode;
import org.cytoscape.equations.parse_tree.StringConstantNode;
import org.cytoscape.equations.parse_tree.UnaryOpNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EqnParserImpl
implements EqnParser {
    private String formula;
    private Tokeniser tokeniser;
    private Map<String, Function> nameToFunctionMap = new HashMap<String, Function>();
    private String lastErrorMessage;
    private Node parseTree = null;
    private Map<String, Class> variableNameToTypeMap;
    private Set<String> variableReferences;
    private Set<Function> registeredFunctions = new HashSet<Function>();

    @Override
    public void registerFunction(Function func) throws IllegalArgumentException {
        String funcName = func.getName().toUpperCase();
        if (funcName == null || funcName.equals("")) {
            throw new IllegalArgumentException("empty or missing function name!");
        }
        if (this.nameToFunctionMap.get(funcName) != null) {
            throw new IllegalArgumentException("attempt at registering " + funcName + "() twice!");
        }
        this.nameToFunctionMap.put(funcName, func);
        this.registeredFunctions.add(func);
    }

    @Override
    public Function getFunction(String functionName) {
        return this.nameToFunctionMap.get(functionName);
    }

    @Override
    public Set<Function> getRegisteredFunctions() {
        return this.registeredFunctions;
    }

    @Override
    public boolean parse(String formula, Map<String, Class> variableNameToTypeMap) {
        if (formula == null) {
            throw new NullPointerException("formula string must not be null!");
        }
        if (formula.length() < 1 || formula.charAt(0) != '=') {
            throw new NullPointerException("0: formula string must start with an equal sign!");
        }
        this.formula = formula;
        this.variableNameToTypeMap = variableNameToTypeMap;
        this.variableReferences = new TreeSet<String>();
        this.tokeniser = new Tokeniser(formula.substring(1));
        this.lastErrorMessage = null;
        try {
            this.parseTree = this.parseExpr();
            Token token = this.tokeniser.getToken();
            int tokenStartPos = this.tokeniser.getStartPos();
            if (token != Token.EOS) {
                throw new IllegalStateException(tokenStartPos + ": premature end of expression: expected EOS, but found " + (Object)((Object)token) + "!");
            }
        }
        catch (IllegalStateException e) {
            this.lastErrorMessage = e.getMessage();
            return false;
        }
        catch (ArithmeticException e) {
            this.lastErrorMessage = e.getMessage();
            return false;
        }
        catch (IllegalArgumentException e) {
            this.lastErrorMessage = e.getMessage();
            return false;
        }
        return true;
    }

    @Override
    public Class getType() {
        return this.parseTree == null ? null : this.parseTree.getType();
    }

    @Override
    public String getErrorMsg() {
        return this.lastErrorMessage;
    }

    @Override
    public Set<String> getVariableReferences() {
        return this.variableReferences;
    }

    @Override
    public Node getParseTree() {
        return this.parseTree;
    }

    private Node parseExpr() {
        Node term;
        int sourceLocation;
        Token token;
        Node exprNode = this.parseTerm();
        while (true) {
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            if (token != Token.PLUS && token != Token.MINUS && token != Token.AMPERSAND) break;
            term = this.parseTerm();
            if (token == Token.PLUS || token == Token.MINUS) {
                exprNode = this.handleBinaryArithmeticOp(token, sourceLocation, exprNode, term);
                continue;
            }
            exprNode = new BinOpNode(sourceLocation, Token.AMPERSAND, exprNode, term);
        }
        if (token.isComparisonOperator()) {
            term = this.parseTerm();
            return this.handleComparisonOp(token, sourceLocation, exprNode, term);
        }
        this.tokeniser.ungetToken(token);
        return exprNode;
    }

    private Node parseTerm() {
        Token token;
        Node termNode = this.parsePower();
        while (true) {
            token = this.tokeniser.getToken();
            int sourceLocation = this.tokeniser.getStartPos();
            if (token != Token.MUL && token != Token.DIV) break;
            Node powerNode = this.parsePower();
            termNode = this.handleBinaryArithmeticOp(token, sourceLocation, termNode, powerNode);
        }
        this.tokeniser.ungetToken(token);
        return termNode;
    }

    private Node parsePower() {
        Node powerNode = this.parseFactor();
        Token token = this.tokeniser.getToken();
        int sourceLocation = this.tokeniser.getStartPos();
        if (token == Token.CARET) {
            Node rhs = this.parsePower();
            powerNode = this.handleBinaryArithmeticOp(token, sourceLocation, powerNode, rhs);
        } else {
            this.tokeniser.ungetToken(token);
        }
        return powerNode;
    }

    private Node parseFactor() {
        Token token = this.tokeniser.getToken();
        int sourceLocation = this.tokeniser.getStartPos();
        if (token == Token.FLOAT_CONSTANT) {
            return new FloatConstantNode(sourceLocation, this.tokeniser.getFloatConstant());
        }
        if (token == Token.STRING_CONSTANT) {
            return new StringConstantNode(sourceLocation, this.tokeniser.getStringConstant());
        }
        if (token == Token.BOOLEAN_CONSTANT) {
            return new BooleanConstantNode(sourceLocation, this.tokeniser.getBooleanConstant());
        }
        if (token == Token.DOLLAR) {
            boolean usingOptionalBraces;
            int varRefStartPos = sourceLocation;
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            boolean bl = usingOptionalBraces = token == Token.OPEN_BRACE;
            if (usingOptionalBraces) {
                token = this.tokeniser.getToken();
                sourceLocation = this.tokeniser.getStartPos();
            }
            if (token != Token.IDENTIFIER) {
                throw new IllegalStateException(sourceLocation + ": identifier expected!");
            }
            Class varRefType = this.variableNameToTypeMap.get(this.tokeniser.getIdent());
            if (varRefType == null) {
                throw new IllegalStateException(sourceLocation + ": unknown variable reference name: \"" + this.tokeniser.getIdent() + "\"!");
            }
            this.variableReferences.add(this.tokeniser.getIdent());
            Object defaultValue = null;
            if (usingOptionalBraces) {
                token = this.tokeniser.getToken();
                if (token == Token.COLON) {
                    token = this.tokeniser.getToken();
                    sourceLocation = this.tokeniser.getStartPos();
                    if (token != Token.FLOAT_CONSTANT && token != Token.STRING_CONSTANT && token != Token.BOOLEAN_CONSTANT) {
                        throw new IllegalStateException(sourceLocation + ": expected default value for variable reference!");
                    }
                    switch (token) {
                        case FLOAT_CONSTANT: {
                            defaultValue = new Double(this.tokeniser.getFloatConstant());
                            break;
                        }
                        case BOOLEAN_CONSTANT: {
                            defaultValue = new Boolean(this.tokeniser.getBooleanConstant());
                            break;
                        }
                        case STRING_CONSTANT: {
                            defaultValue = new String(this.tokeniser.getStringConstant());
                        }
                    }
                    token = this.tokeniser.getToken();
                    sourceLocation = this.tokeniser.getStartPos();
                }
                if (token != Token.CLOSE_BRACE) {
                    throw new IllegalStateException(sourceLocation + ": closing brace expected!");
                }
            }
            return new IdentNode(varRefStartPos, this.tokeniser.getIdent(), defaultValue, varRefType);
        }
        if (token == Token.OPEN_PAREN) {
            Node exprNode = this.parseExpr();
            token = this.tokeniser.getToken();
            if (token != Token.CLOSE_PAREN) {
                throw new IllegalStateException(sourceLocation + ": '(' expected!");
            }
            return exprNode;
        }
        if (token == Token.PLUS || token == Token.MINUS) {
            Node factor = this.parseFactor();
            return this.handleUnaryOp(sourceLocation, token, factor);
        }
        if (token == Token.IDENTIFIER) {
            this.tokeniser.ungetToken(token);
            return this.parseFunctionCall();
        }
        if (token == Token.ERROR) {
            throw new IllegalStateException(sourceLocation + ": " + this.tokeniser.getErrorMsg());
        }
        throw new IllegalStateException(sourceLocation + ": unexpected input token: " + (Object)((Object)token) + "!");
    }

    private Node handleUnaryOp(int sourceLocation, Token operator, Node operand) {
        if (operand.getType() == Boolean.class || operand.getType() == String.class) {
            throw new ArithmeticException(sourceLocation + ": can't apply a unary " + operator.asString() + " a boolean, string or list operand!");
        }
        return new UnaryOpNode(sourceLocation, operator, operand);
    }

    private Node parseFunctionCall() {
        int sourceLocation;
        Token token = this.tokeniser.getToken();
        int functionNameStartPos = this.tokeniser.getStartPos();
        if (token != Token.IDENTIFIER) {
            throw new IllegalStateException(functionNameStartPos + ": function name expected!");
        }
        String functionNameCandidate = this.tokeniser.getIdent().toUpperCase();
        if (functionNameCandidate.equals("DEFINED")) {
            return this.parseDefined();
        }
        Function func = this.nameToFunctionMap.get(functionNameCandidate);
        if (func == null) {
            throw new IllegalStateException(functionNameStartPos + ": call to unknown function " + functionNameCandidate + "()!");
        }
        token = this.tokeniser.getToken();
        int openParenPos = this.tokeniser.getStartPos();
        if (token != Token.OPEN_PAREN) {
            throw new IllegalStateException(openParenPos + ": expected '(' after function name \"" + functionNameCandidate + "\"!");
        }
        ArrayList<Class> argTypes = new ArrayList<Class>();
        ArrayList<Node> args = new ArrayList<Node>();
        do {
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            if (token == Token.CLOSE_PAREN) break;
            this.tokeniser.ungetToken(token);
            Node exprNode = this.parseExpr();
            argTypes.add(exprNode.getType());
            args.add(exprNode);
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
        } while (token == Token.COMMA);
        Class returnType = func.validateArgTypes(argTypes.toArray(new Class[argTypes.size()]));
        if (returnType == null) {
            throw new IllegalStateException(openParenPos + 1 + ": invalid number or type of arguments in call to " + functionNameCandidate + "()!");
        }
        if (token != Token.CLOSE_PAREN) {
            throw new IllegalStateException(sourceLocation + ": expected the closing parenthesis of a call to " + functionNameCandidate + "!");
        }
        Node[] nodeArray = new Node[args.size()];
        return new FuncCallNode(functionNameStartPos, func, returnType, args.toArray(nodeArray));
    }

    private Node parseDefined() {
        Class varRefType;
        Token token = this.tokeniser.getToken();
        int definedStart = this.tokeniser.getStartPos();
        if (token != Token.OPEN_PAREN) {
            throw new IllegalStateException(definedStart + ": \"(\" expected after \"DEFINED\"!");
        }
        token = this.tokeniser.getToken();
        int sourceLocation = this.tokeniser.getStartPos();
        if (token != Token.DOLLAR) {
            if (token != Token.IDENTIFIER) {
                throw new IllegalStateException(sourceLocation + ": variable reference expected after \"DEFINED(\"!");
            }
            varRefType = this.variableNameToTypeMap.get(this.tokeniser.getIdent());
        } else {
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            if (token != Token.OPEN_BRACE) {
                throw new IllegalStateException(sourceLocation + ": \"{\" expected after \"DEFINED($\"!");
            }
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            if (token != Token.IDENTIFIER) {
                throw new IllegalStateException(sourceLocation + ": variable reference expected after \"DEFINED(${\"!");
            }
            varRefType = this.variableNameToTypeMap.get(this.tokeniser.getIdent());
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            if (token != Token.CLOSE_BRACE) {
                throw new IllegalStateException(sourceLocation + ":\"}\" expected after after \"DEFINED(${" + this.tokeniser.getIdent() + "\"!");
            }
        }
        token = this.tokeniser.getToken();
        sourceLocation = this.tokeniser.getStartPos();
        if (token != Token.CLOSE_PAREN) {
            throw new IllegalStateException(sourceLocation + ": missing \")\" in call to DEFINED()!");
        }
        return new BooleanConstantNode(definedStart, varRefType != null);
    }

    private Node handleBinaryArithmeticOp(Token operator, int sourceLocation, Node lhs, Node rhs) {
        if (lhs.getType() == Double.class && rhs.getType() == Double.class) {
            return new BinOpNode(sourceLocation, operator, lhs, rhs);
        }
        if (lhs.getType() == Double.class && (rhs.getType() == Long.class || rhs.getType() == Boolean.class || rhs.getType() == String.class)) {
            return new BinOpNode(sourceLocation, operator, lhs, new FConvNode(rhs));
        }
        if (lhs.getType() == Long.class && rhs.getType() == Double.class) {
            return new BinOpNode(sourceLocation, operator, new FConvNode(lhs), rhs);
        }
        if (lhs.getType() == Long.class && (rhs.getType() == Long.class || rhs.getType() == Boolean.class || rhs.getType() == String.class)) {
            return new BinOpNode(sourceLocation, operator, new FConvNode(lhs), new FConvNode(rhs));
        }
        if (lhs.getType() == Boolean.class && rhs.getType() == Double.class) {
            return new BinOpNode(sourceLocation, operator, new FConvNode(lhs), rhs);
        }
        if (lhs.getType() == Boolean.class && (rhs.getType() == Long.class || rhs.getType() == Boolean.class || rhs.getType() == String.class)) {
            return new BinOpNode(sourceLocation, operator, new FConvNode(lhs), new FConvNode(rhs));
        }
        if (lhs.getType() == String.class && rhs.getType() == Double.class) {
            return new BinOpNode(sourceLocation, operator, new FConvNode(lhs), rhs);
        }
        if (lhs.getType() == String.class && (rhs.getType() == Long.class || lhs.getType() == Boolean.class || lhs.getType() == String.class)) {
            return new BinOpNode(sourceLocation, operator, new FConvNode(lhs), new FConvNode(rhs));
        }
        throw new ArithmeticException(sourceLocation + ": incompatible operands for \"" + operator.asString() + "\"! (lhs=" + lhs.toString() + ":" + lhs.getType() + ", rhs=" + rhs.toString() + ":" + rhs.getType() + ")");
    }

    private Node handleComparisonOp(Token operator, int sourceLocation, Node lhs, Node rhs) {
        if (lhs.getType() == Double.class && rhs.getType() == Double.class) {
            return new BinOpNode(sourceLocation, operator, lhs, rhs);
        }
        if (lhs.getType() == Double.class && rhs.getType() == Long.class) {
            return new BinOpNode(sourceLocation, operator, lhs, new FConvNode(rhs));
        }
        if (lhs.getType() == Double.class && rhs.getType() == Boolean.class) {
            return new BinOpNode(sourceLocation, operator, lhs, new FConvNode(rhs));
        }
        if (lhs.getType() == Double.class && rhs.getType() == Long.class) {
            return new BinOpNode(sourceLocation, operator, lhs, new FConvNode(rhs));
        }
        if (lhs.getType() == Long.class && rhs.getType() == Double.class) {
            return new BinOpNode(sourceLocation, operator, new FConvNode(lhs), rhs);
        }
        if (lhs.getType() == Long.class && (rhs.getType() == Long.class || rhs.getType() == Boolean.class || rhs.getType() == String.class)) {
            return new BinOpNode(sourceLocation, operator, new FConvNode(lhs), new FConvNode(rhs));
        }
        if (lhs.getType() == Boolean.class && rhs.getType() == Boolean.class) {
            return new BinOpNode(sourceLocation, operator, lhs, rhs);
        }
        if (lhs.getType() == Boolean.class && rhs.getType() == Double.class) {
            return new BinOpNode(sourceLocation, operator, new FConvNode(lhs), rhs);
        }
        if (lhs.getType() == Boolean.class && rhs.getType() == Long.class) {
            return new BinOpNode(sourceLocation, operator, new FConvNode(lhs), new FConvNode(rhs));
        }
        if (lhs.getType() == Boolean.class && rhs.getType() == String.class) {
            return new BinOpNode(sourceLocation, operator, new SConvNode(lhs), rhs);
        }
        if (lhs.getType() == String.class && rhs.getType() == String.class) {
            return new BinOpNode(sourceLocation, operator, lhs, rhs);
        }
        if (lhs.getType() == String.class && (rhs.getType() == Double.class || rhs.getType() == Long.class || rhs.getType() == Boolean.class)) {
            return new BinOpNode(sourceLocation, operator, lhs, new SConvNode(rhs));
        }
        throw new IllegalArgumentException(sourceLocation + ": incompatible operands for \"" + operator.asString() + "\"! (lhs=" + lhs.toString() + ":" + lhs.getType() + ", rhs=" + rhs.toString() + ":" + rhs.getType() + ")");
    }
}

