/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import ding.view.DGraphView;
import ding.view.DingCanvas;
import ding.view.InnerCanvas;
import ding.view.ViewportChangeListener;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class ArbitraryGraphicsCanvas
extends DingCanvas
implements ViewportChangeListener {
    private static final boolean USE_REPOSITION_CODE = false;
    private final GraphPerspective m_graphPerspective;
    private final DGraphView m_dGraphView;
    private final InnerCanvas m_innerCanvas;
    private final Map<Component, Node> m_componentToNodeMap;

    public ArbitraryGraphicsCanvas(GraphPerspective graphPerspective, DGraphView dGraphView, InnerCanvas innerCanvas, Color backgroundColor, boolean isVisible, boolean isOpaque) {
        this.m_graphPerspective = graphPerspective;
        this.m_dGraphView = dGraphView;
        this.m_innerCanvas = innerCanvas;
        this.m_backgroundColor = backgroundColor;
        this.m_isVisible = isVisible;
        this.m_isOpaque = isOpaque;
        this.m_componentToNodeMap = new HashMap<Component, Node>();
    }

    public Component add(Component component) {
        return super.add(component);
    }

    public void viewportChanged(int viewportWidth, int viewportHeight, double newXCenter, double newYCenter, double newScaleFactor) {
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > 1 && height > 1) {
            this.m_img = new BufferedImage(width, height, 2);
        }
    }

    public void paint(Graphics graphics) {
        if (this.m_img != null) {
            Graphics2D image2D = ((BufferedImage)this.m_img).createGraphics();
            this.clearImage(image2D);
            if (this.m_isVisible) {
                this.paintChildren(image2D);
            }
            graphics.drawImage(this.m_img, 0, 0, null);
        }
    }

    public void print(Graphics graphics) {
        if (this.m_img != null) {
            graphics.drawImage(this.m_img, 0, 0, null);
        }
    }

    private boolean setBoundsChildren() {
        Component[] components = this.getComponents();
        if (components.length == 0) {
            return false;
        }
        for (Component c : components) {
            Node node = this.m_componentToNodeMap.get(c);
            NodeView nodeView = this.m_dGraphView.getNodeView(node);
            double[] currentNodeCoordinates = new double[]{nodeView.getXPosition(), nodeView.getYPosition()};
            AffineTransform transform = this.m_innerCanvas.getAffineTransform();
            transform.transform(currentNodeCoordinates, 0, currentNodeCoordinates, 0, 1);
            c.setBounds((int)currentNodeCoordinates[0], (int)currentNodeCoordinates[1], c.getWidth(), c.getHeight());
        }
        return true;
    }

    private void clearImage(Graphics2D image2D) {
        int alpha = this.m_isOpaque ? 255 : 0;
        Color backgroundColor = new Color(this.m_backgroundColor.getRed(), this.m_backgroundColor.getGreen(), this.m_backgroundColor.getBlue(), alpha);
        Composite origComposite = image2D.getComposite();
        image2D.setComposite(AlphaComposite.getInstance(2));
        image2D.setPaint(backgroundColor);
        image2D.fillRect(0, 0, this.m_img.getWidth(null), this.m_img.getHeight(null));
        image2D.setComposite(origComposite);
    }
}

