/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.util.CyColorChooser;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.ui.DefaultViewPanel;
import cytoscape.visual.ui.VizMapperMainPanel;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.LineBorder;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.border.DropShadowBorder;

public class DefaultAppearenceBuilder
extends JDialog {
    private static final long serialVersionUID = 596165395462496156L;
    private static final int VIEW_WIDTH = 350;
    private static final int LIST_WIDTH = 550;
    private static final Dimension DIALOG_SIZE = new Dimension(900, 500);
    private static final Set<VisualPropertyType> EDGE_PROPS;
    private static final Set<VisualPropertyType> NODE_PROPS;
    private static final CyLogger logger;
    private static DefaultAppearenceBuilder dab;
    private JButton applyButton;
    private JButton cancelButton;
    private JScrollPane nodeScrollPane;
    private JScrollPane edgeScrollPane;
    private JScrollPane globalScrollPane;
    private JScrollPane dependencyScrollPane;
    private JTabbedPane defaultObjectTabbedPane;
    private JXList nodeList;
    private JXList edgeList;
    private JXList globalList;
    private JPanel dependencyPanel;
    private JXPanel jXPanel1;
    private Map<VisualPropertyDependency.Definition, JCheckBox> dependencyCheckBoxMap;
    private JXTitledPanel jXTitledPanel1;
    protected DefaultViewPanel mainView;

    private DefaultAppearenceBuilder(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.buildList();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                DefaultAppearenceBuilder.this.mainView.updateView();
            }
        });
    }

    static JPanel showDialog(Frame parent) {
        if (dab == null) {
            dab = new DefaultAppearenceBuilder(parent, true);
        }
        dab.setSize(DIALOG_SIZE);
        dab.buildList();
        DefaultAppearenceBuilder.dab.mainView.updateView();
        dab.setLocationRelativeTo(parent);
        dab.setVisible(true);
        return dab.getPanel();
    }

    static final JPanel getDefaultView(String vsName) {
        if (dab == null) {
            dab = new DefaultAppearenceBuilder((Frame)Cytoscape.getDesktop(), true);
        }
        DefaultAppearenceBuilder.dab.mainView.updateBackgroungColor(Cytoscape.getVisualMappingManager().getVisualStyle().getGlobalAppearanceCalculator().getDefaultBackgroundColor());
        dab.buildList();
        return dab.getPanel();
    }

    private void initComponents() {
        this.jXPanel1 = new JXPanel();
        this.mainView = DefaultViewPanel.getDefaultViewPanel();
        this.jXTitledPanel1 = new JXTitledPanel();
        this.defaultObjectTabbedPane = new JTabbedPane();
        this.nodeScrollPane = new JScrollPane();
        this.edgeScrollPane = new JScrollPane();
        this.globalScrollPane = new JScrollPane();
        this.dependencyScrollPane = new JScrollPane();
        this.nodeList = new JXList();
        this.edgeList = new JXList();
        this.globalList = new JXList();
        this.initDependencyPanel();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.cancelButton.setVisible(false);
        this.nodeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DefaultAppearenceBuilder.this.listActionPerformed(e);
            }
        });
        this.edgeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DefaultAppearenceBuilder.this.listActionPerformed(e);
            }
        });
        this.globalList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DefaultAppearenceBuilder.this.globalListActionPerformed(e);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle("Default Appearance for " + Cytoscape.getVisualMappingManager().getVisualStyle().getName());
        this.mainView.setPreferredSize(new Dimension(350, 300));
        this.mainView.setBorder(new LineBorder(Color.darkGray, 1, true));
        GroupLayout jXPanel2Layout = new GroupLayout(this.mainView);
        this.mainView.setLayout(jXPanel2Layout);
        jXPanel2Layout.setHorizontalGroup(jXPanel2Layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
        jXPanel2Layout.setVerticalGroup(jXPanel2Layout.createParallelGroup(1).add(0, 237, Short.MAX_VALUE));
        this.jXTitledPanel1.setTitle("Default Visual Properties");
        this.jXTitledPanel1.setTitleFont(new Font("SansSerif", 1, 12));
        this.jXTitledPanel1.setPreferredSize(new Dimension(550, 300));
        this.defaultObjectTabbedPane.setTabPlacement(3);
        this.nodeScrollPane.setViewportView(this.nodeList);
        this.edgeScrollPane.setViewportView(this.edgeList);
        this.globalScrollPane.setViewportView(this.globalList);
        this.dependencyScrollPane.setViewportView(this.dependencyPanel);
        this.defaultObjectTabbedPane.addTab("Node", this.nodeScrollPane);
        this.defaultObjectTabbedPane.addTab("Edge", this.edgeScrollPane);
        this.defaultObjectTabbedPane.addTab("Global", this.globalScrollPane);
        this.defaultObjectTabbedPane.addTab("Dependencies", this.dependencyScrollPane);
        GroupLayout jXTitledPanel1Layout = new GroupLayout(this.jXTitledPanel1.getContentContainer());
        this.jXTitledPanel1.getContentContainer().setLayout(jXTitledPanel1Layout);
        jXTitledPanel1Layout.setHorizontalGroup(jXTitledPanel1Layout.createParallelGroup(1).add(this.defaultObjectTabbedPane, -1, 250, Short.MAX_VALUE));
        jXTitledPanel1Layout.setVerticalGroup(jXTitledPanel1Layout.createParallelGroup(1).add(this.defaultObjectTabbedPane, -1, 243, Short.MAX_VALUE));
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Cytoscape.getVisualMappingManager().setNetworkView(Cytoscape.getCurrentNetworkView());
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                DefaultAppearenceBuilder.this.dispose();
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DefaultAppearenceBuilder.this.dispose();
            }
        });
        GroupLayout jXPanel1Layout = new GroupLayout(this.jXPanel1);
        this.jXPanel1.setLayout(jXPanel1Layout);
        jXPanel1Layout.setHorizontalGroup(jXPanel1Layout.createParallelGroup(1).add(jXPanel1Layout.createSequentialGroup().addContainerGap().add(jXPanel1Layout.createParallelGroup(1).add(jXPanel1Layout.createSequentialGroup().addPreferredGap(0).add(this.cancelButton).addPreferredGap(0).add(this.applyButton)).add(this.mainView, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(this.jXTitledPanel1, -2, 500, Short.MAX_VALUE).add(12, 12, 12)));
        jXPanel1Layout.setVerticalGroup(jXPanel1Layout.createParallelGroup(1).add(2, jXPanel1Layout.createSequentialGroup().addContainerGap().add(jXPanel1Layout.createParallelGroup(2).add(1, this.jXTitledPanel1, -1, 270, Short.MAX_VALUE).add(jXPanel1Layout.createSequentialGroup().add(this.mainView, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(jXPanel1Layout.createParallelGroup(3).add(this.cancelButton).add(this.applyButton)))).addContainerGap()));
        this.getContentPane().add(this.jXPanel1);
        this.pack();
    }

    private void listActionPerformed(MouseEvent e) {
        if (e.getClickCount() == 1) {
            Object newValue = null;
            JXList list = e.getSource() == this.nodeList ? this.nodeList : this.edgeList;
            try {
                newValue = VizMapperMainPanel.showValueSelectDialog((VisualPropertyType)((Object)list.getSelectedValue()), this);
                VizMapperMainPanel.apply(newValue, (VisualPropertyType)((Object)list.getSelectedValue()));
            }
            catch (Exception e1) {
                logger.warn("Unable to show VizMapper value select dialog!", e1);
                e1.printStackTrace();
            }
            this.buildList();
            Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
        }
    }

    private void globalListActionPerformed(MouseEvent e) {
        if (e.getClickCount() == 1) {
            String selected = (String)this.globalList.getSelectedValue();
            Color newColor = CyColorChooser.showDialog(this, "Choose new color.", Color.white);
            try {
                Cytoscape.getVisualMappingManager().getVisualStyle().getGlobalAppearanceCalculator().setDefaultColor(selected, newColor);
                Cytoscape.getVisualMappingManager().applyGlobalAppearances();
            }
            catch (Exception e1) {
                logger.warn("Unable to set default color!", e1);
            }
            this.buildList();
            Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            if (selected.equals("Background Color")) {
                Cytoscape.getVisualMappingManager().applyGlobalAppearances();
                this.mainView.updateBackgroungColor(newColor);
            }
            this.mainView.updateView();
            this.mainView.repaint();
        }
    }

    private JPanel getPanel() {
        return this.mainView;
    }

    private void buildList() {
        this.syncDependencies();
        ArrayList<Icon> nodeIcons = new ArrayList<Icon>();
        ArrayList<Icon> edgeIcons = new ArrayList<Icon>();
        ArrayList<Icon> globalIcons = new ArrayList<Icon>();
        DefaultListModel<VisualPropertyType> model = new DefaultListModel<VisualPropertyType>();
        this.nodeList.setModel((ListModel)model);
        for (VisualPropertyType type : NODE_PROPS) {
            VisualPropertyIcon nodeIcon = (VisualPropertyIcon)type.getVisualProperty().getDefaultIcon();
            nodeIcon.setLeftPadding(15);
            model.addElement(type);
            nodeIcons.add(nodeIcon);
        }
        DefaultListModel<VisualPropertyType> eModel = new DefaultListModel<VisualPropertyType>();
        this.edgeList.setModel((ListModel)eModel);
        for (VisualPropertyType type : EDGE_PROPS) {
            VisualPropertyIcon edgeIcon = (VisualPropertyIcon)type.getVisualProperty().getDefaultIcon();
            if (edgeIcon == null) continue;
            edgeIcon.setLeftPadding(15);
            eModel.addElement(type);
            edgeIcons.add(edgeIcon);
        }
        GlobalAppearanceCalculator gac = Cytoscape.getVisualMappingManager().getVisualStyle().getGlobalAppearanceCalculator();
        DefaultListModel<String> gModel = new DefaultListModel<String>();
        this.globalList.setModel((ListModel)gModel);
        for (String name : gac.getGlobalAppearanceNames()) {
            try {
                globalIcons.add(new GlobalIcon(name, gac.getDefaultColor(name)));
            }
            catch (Exception e) {
                logger.warn("Unable to add default color icon!", e);
            }
            gModel.addElement(name);
        }
        this.nodeList.setCellRenderer((ListCellRenderer)new VisualPropCellRenderer(nodeIcons));
        this.edgeList.setCellRenderer((ListCellRenderer)new VisualPropCellRenderer(edgeIcons));
        this.globalList.setCellRenderer((ListCellRenderer)new VisualPropCellRenderer(globalIcons));
        this.mainView.updateView();
        this.mainView.repaint();
    }

    private void syncDependencies() {
        VisualPropertyDependency dep = Cytoscape.getVisualMappingManager().getVisualStyle().getDependency();
        for (VisualPropertyType type : VisualPropertyType.values()) {
            if (!type.isAllowed()) continue;
            if (type.isNodeProp()) {
                if (type.getVisualProperty().constrained(dep)) {
                    NODE_PROPS.remove((Object)type);
                    continue;
                }
                NODE_PROPS.add(type);
                continue;
            }
            if (type.getVisualProperty().constrained(dep)) {
                EDGE_PROPS.remove((Object)type);
                continue;
            }
            EDGE_PROPS.add(type);
        }
        for (VisualPropertyDependency.Definition def : this.dependencyCheckBoxMap.keySet()) {
            this.dependencyCheckBoxMap.get((Object)def).setSelected(dep.check(def));
        }
    }

    private void initDependencyPanel() {
        this.dependencyPanel = new JPanel();
        this.dependencyCheckBoxMap = new HashMap<VisualPropertyDependency.Definition, JCheckBox>();
        this.dependencyPanel.setLayout(new BoxLayout(this.dependencyPanel, 1));
        VisualPropertyDependency dep = Cytoscape.getVisualMappingManager().getVisualStyle().getDependency();
        for (final VisualPropertyDependency.Definition def : VisualPropertyDependency.Definition.values()) {
            final JCheckBox dCheck = new JCheckBox();
            dCheck.setSelected(dep.check(def));
            dCheck.setFont(new Font("SansSerif", 1, 12));
            dCheck.setText(def.getTitle());
            dCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            dCheck.setMargin(new Insets(0, 0, 0, 0));
            this.dependencyPanel.add(dCheck);
            this.dependencyCheckBoxMap.put(def, dCheck);
            dCheck.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    VisualPropertyDependency deps = Cytoscape.getVisualMappingManager().getVisualStyle().getDependency();
                    deps.set(def, dCheck.isSelected());
                    Cytoscape.getDesktop().getVizMapperUI().syncDependencyStates(deps, def);
                    DefaultAppearenceBuilder.this.buildList();
                    DefaultAppearenceBuilder.this.mainView.updateView();
                    DefaultAppearenceBuilder.this.repaint();
                }
            });
        }
    }

    static {
        logger = CyLogger.getLogger(DefaultAppearenceBuilder.class);
        dab = null;
        EDGE_PROPS = new TreeSet<VisualPropertyType>(VisualPropertyType.getEdgeVisualPropertyList());
        NODE_PROPS = new TreeSet<VisualPropertyType>(VisualPropertyType.getNodeVisualPropertyList());
    }

    static class GlobalIcon
    extends VisualPropertyIcon {
        private static final long serialVersionUID = -2292185584380604923L;

        public GlobalIcon(String name, Color color) {
            super(name, color);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(this.color);
            g2d.fillRect(5, 3, 50, 32);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setColor(Color.DARK_GRAY);
            g2d.drawRect(5, 3, 50, 32);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VisualPropCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -4980971466313937239L;
        private final Font SELECTED_FONT = new Font("SansSerif", 2, 14);
        private final Font NORMAL_FONT = new Font("SansSerif", 1, 12);
        private final Color SELECTED_COLOR = new Color(10, 50, 180, 20);
        private final Color SELECTED_FONT_COLOR = new Color(0, 150, 255, 150);
        private final List<Icon> icons;

        public VisualPropCellRenderer(List<Icon> icons) {
            this.icons = icons;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object defVal;
            VisualPropertyIcon icon = this.icons.size() > index ? (VisualPropertyIcon)this.icons.get(index) : null;
            this.setText(value.toString());
            this.setIcon(icon);
            this.setFont(isSelected ? this.SELECTED_FONT : this.NORMAL_FONT);
            this.setVerticalTextPosition(0);
            this.setVerticalAlignment(0);
            this.setIconTextGap(120);
            if (value instanceof VisualPropertyType && ((VisualPropertyType)((Object)value)).getDataType() == String.class && (defVal = ((VisualPropertyType)((Object)value)).getDefault(Cytoscape.getVisualMappingManager().getVisualStyle())) != null) {
                this.setToolTipText((String)defVal);
            }
            this.setBackground(isSelected ? this.SELECTED_COLOR : list.getBackground());
            this.setForeground(isSelected ? this.SELECTED_FONT_COLOR : list.getForeground());
            if (icon != null) {
                this.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight() + 12));
            }
            this.setBorder(new DropShadowBorder());
            return this;
        }
    }
}

