/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.LineTypeIcon;
import giny.view.EdgeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;

public class EdgeLabelWidthProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_LABEL_WIDTH;
    }

    public Icon getIcon(final Object value) {
        LineTypeIcon icon = new LineTypeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 0));
                super.paintIcon(c, g, x, y);
                this.g2d.setFont(new Font("SansSerif", 1, 24));
                this.g2d.setColor(Color.DARK_GRAY);
                this.g2d.drawString(value.toString(), c.getX() + 48, c.getHeight() / 2 + 7);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
            }
        };
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o, VisualPropertyDependency dep) {
        if (o == null || ev == null) {
            return;
        }
        float width = ((Number)o).floatValue();
        if (ev.getLabelWidth() != (double)width) {
            ev.setLabelWidth(width);
        }
    }

    public Object getDefaultAppearanceObject() {
        return new Float(100.0f);
    }
}

