/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic.ui;

import cytoscape.Cytoscape;
import cytoscape.visual.customgraphic.CustomGraphicsManager;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.customgraphic.impl.bitmap.URLImageCustomGraphics;
import cytoscape.visual.customgraphic.ui.CustomGraphicsBrowser;
import cytoscape.visual.customgraphic.ui.CustomGraphicsDetailPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.jdesktop.layout.GroupLayout;

public class CustomGraphicsManagerDialog
extends JDialog {
    private static final long serialVersionUID = 7681270324415099781L;
    private CustomGraphicsBrowser browser;
    private final CustomGraphicsDetailPanel detail;
    private final CustomGraphicsManager pool = Cytoscape.getVisualMappingManager().getCustomGraphicsManager();
    private JButton addButton;
    private JPanel buttonPanel;
    private JButton deleteButton;
    private JScrollPane leftScrollPane;
    private JSplitPane mainSplitPane;
    private JScrollPane rightScrollPane;

    public CustomGraphicsManagerDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        try {
            this.browser = new CustomGraphicsBrowser();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.detail = new CustomGraphicsDetailPanel();
        this.leftScrollPane.setViewportView(this.browser);
        this.rightScrollPane.setViewportView(this.detail);
        this.setPreferredSize(new Dimension(850, 550));
        this.setTitle("Custom Graphics Manager");
        this.browser.addListSelectionListener(this.detail);
        this.pack();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.deleteButton = new JButton();
        this.addButton = new JButton();
        this.mainSplitPane = new JSplitPane();
        this.leftScrollPane = new JScrollPane();
        this.rightScrollPane = new JScrollPane();
        this.setDefaultCloseOperation(2);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.deleteButton.setText("-");
        this.deleteButton.setToolTipText("Remove selected graphics from library.");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomGraphicsManagerDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        this.addButton.setText("+");
        this.addButton.setToolTipText("Add a folder to Custom Graphics Library");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomGraphicsManagerDialog.this.addButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(1).add(2, buttonPanelLayout.createSequentialGroup().addContainerGap(580, Short.MAX_VALUE).add(this.addButton, -2, 50, -2).addPreferredGap(0).add(this.deleteButton, -2, 50, -2)));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(1).add(buttonPanelLayout.createParallelGroup(3).add(this.deleteButton).add(this.addButton)));
        this.mainSplitPane.setDividerLocation(230);
        this.mainSplitPane.setLeftComponent(this.leftScrollPane);
        this.mainSplitPane.setRightComponent(this.rightScrollPane);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, this.buttonPanel, -1, -1, Short.MAX_VALUE).add(this.mainSplitPane, -1, 690, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.mainSplitPane, -1, 552, Short.MAX_VALUE).addPreferredGap(0).add(this.buttonPanel, -2, -1, -2)));
        this.pack();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Image Directory");
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.importFromDirectories(chooser.getSelectedFiles());
        }
    }

    private void importFromDirectories(File[] directories) {
        for (File file : directories) {
            this.processFiles(file.listFiles());
        }
    }

    private void processFiles(File[] files) {
        for (File file : files) {
            BufferedImage img = null;
            if (file.isFile()) {
                try {
                    img = ImageIO.read(file);
                }
                catch (IOException e) {
                    System.err.println("Could not read file: " + file.toString());
                    e.printStackTrace();
                    continue;
                }
            }
            if (img == null) continue;
            URLImageCustomGraphics cg = new URLImageCustomGraphics(file.toString(), img);
            try {
                this.pool.addGraphics(cg, file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                continue;
            }
            ((DefaultListModel)this.browser.getModel()).addElement(cg);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        Object[] toBeRemoved;
        for (Object g : toBeRemoved = this.browser.getSelectedValues()) {
            CyCustomGraphics cg = (CyCustomGraphics)g;
            this.browser.removeCustomGraphics(cg);
            this.pool.removeGraphics(cg.getIdentifier());
        }
    }
}

