/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.command;

import cytoscape.command.CyCommandException;
import cytoscape.command.CyCommandHandler;
import cytoscape.command.CyCommandNamespace;
import cytoscape.command.CyCommandResult;
import cytoscape.layout.Tunable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyCommandManager {
    private static Map<CyCommandNamespace, Map<String, CyCommandHandler>> comMap = new HashMap<CyCommandNamespace, Map<String, CyCommandHandler>>();
    private static Map<String, CyCommandNamespace> nsMap = new HashMap<String, CyCommandNamespace>();

    public static CyCommandNamespace reserveNamespace(String namespace) throws RuntimeException {
        if (namespace == null || namespace.length() == 0) {
            return null;
        }
        if (nsMap.containsKey(namespace = namespace.toLowerCase())) {
            throw new RuntimeException("Command namespace: " + namespace + " is already reserved");
        }
        CyCommandNamespaceImpl ns = new CyCommandNamespaceImpl(namespace);
        nsMap.put(namespace, ns);
        comMap.put(ns, new HashMap());
        return ns;
    }

    public static void register(CyCommandNamespace ns, String command, CyCommandHandler com) throws RuntimeException {
        if (com == null) {
            return;
        }
        if (!comMap.containsKey(ns)) {
            throw new RuntimeException("Command namespace: " + ns.getNamespaceName() + " is not yet registered");
        }
        Map<String, CyCommandHandler> subComMap = comMap.get(ns);
        if (subComMap.containsKey(command)) {
            throw new RuntimeException("Command: " + ns.getNamespaceName() + " " + command + " already exists!");
        }
        subComMap.put(command, com);
    }

    public static CyCommandHandler getCommand(String namespace, String name) {
        if (namespace == null || namespace.length() == 0) {
            throw new RuntimeException("null or zero length namespace");
        }
        namespace = namespace.toLowerCase();
        if (name == null || name.length() == 0) {
            throw new RuntimeException("null or zero length command name");
        }
        CyCommandNamespace ns = nsMap.get(namespace);
        if (ns == null) {
            throw new RuntimeException("namespace '" + namespace + "' does not exist!");
        }
        Map<String, CyCommandHandler> subComMap = comMap.get(ns);
        return subComMap.get(name);
    }

    public static List<String> getNamespaceList() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(nsMap.keySet());
        return list;
    }

    public static Map<String, List<CyCommandHandler>> getCommandMap() {
        HashMap<String, List<CyCommandHandler>> map = new HashMap<String, List<CyCommandHandler>>();
        for (CyCommandNamespace namespace : comMap.keySet()) {
            ArrayList<CyCommandHandler> list = new ArrayList<CyCommandHandler>();
            list.addAll(comMap.get(namespace).values());
            map.put(namespace.getNamespaceName(), list);
        }
        return map;
    }

    public static List<String> getCommandList(String namespace) {
        ArrayList<String> list = new ArrayList<String>();
        if (!nsMap.containsKey(namespace)) {
            return null;
        }
        CyCommandNamespace ns = nsMap.get(namespace.toLowerCase());
        if (comMap.containsKey(ns)) {
            list.addAll(comMap.get(ns).keySet());
        }
        return list;
    }

    public static CyCommandResult execute(String namespace, String command, Map<String, Object> arguments) throws CyCommandException, RuntimeException {
        CyCommandHandler handler = CyCommandManager.getHandler(namespace, command);
        return handler.execute(command, arguments);
    }

    public static CyCommandResult execute(String namespace, String command, List<Tunable> arguments) throws CyCommandException, RuntimeException {
        CyCommandHandler handler = CyCommandManager.getHandler(namespace, command);
        return handler.execute(command, arguments);
    }

    private static CyCommandHandler getHandler(String namespace, String command) {
        if (!nsMap.containsKey(namespace)) {
            throw new RuntimeException("The namespace " + namespace + " is unknown");
        }
        CyCommandNamespace ns = nsMap.get(namespace);
        Map<String, CyCommandHandler> subComMap = comMap.get(ns);
        if (!subComMap.containsKey(command)) {
            throw new RuntimeException("The command " + namespace + " " + command + " isn't registered");
        }
        return subComMap.get(command);
    }

    private static class CyCommandNamespaceImpl
    implements CyCommandNamespace {
        private String ns;

        protected CyCommandNamespaceImpl(String namespace) {
            this.ns = namespace;
        }

        public String getNamespaceName() {
            return this.ns;
        }
    }
}

