/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.CustomizableScreen;
import com.install4j.runtime.installer.frontend.components.DirectorySelector;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JPanel;

public class CustomizableDirectoryScreen
extends CustomizableScreen {
    private String variableName = "";
    private String initialDirectory = "";
    private String standardDirectoryName = "";
    private boolean onlyWritable = false;
    private String directoryDescription = "";
    private String infoText = "";
    private DirectorySelector directorySelector;
    private boolean initialized;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getInitialDirectory() {
        return CustomizableDirectoryScreen.replaceVariables(this.initialDirectory);
    }

    public void setInitialDirectory(String string) {
        this.initialDirectory = string;
    }

    public String getStandardDirectoryName() {
        return CustomizableDirectoryScreen.replaceVariables(this.standardDirectoryName);
    }

    public void setStandardDirectoryName(String string) {
        this.standardDirectoryName = string;
    }

    public boolean isOnlyWritable() {
        return this.onlyWritable;
    }

    public void setOnlyWritable(boolean bl) {
        this.onlyWritable = bl;
    }

    public String getDirectoryDescription() {
        return this.directoryDescription;
    }

    public void setDirectoryDescription(String string) {
        this.directoryDescription = string;
    }

    public String getInfoText() {
        return this.infoText;
    }

    public void setInfoText(String string) {
        this.infoText = string;
    }

    public boolean handleUnattended() {
        this.setDirectory(new File(this.getUsedInitialDirectory()));
        return true;
    }

    private String getUsedInitialDirectory() {
        Object object = this.getContext().getVariable(this.getVariableName());
        if (object != null && object instanceof String) {
            return (String)object;
        }
        return this.getInitialDirectory();
    }

    public void setInstallerContext(InstallerContext installerContext) {
        super.setInstallerContext(installerContext);
        this.addVariableListener();
    }

    public void setUninstallerContext(UninstallerContext uninstallerContext) {
        super.setUninstallerContext(uninstallerContext);
        this.addVariableListener();
    }

    private void addVariableListener() {
        this.getContext().addInstallerEventListener(new InstallerEventListener(){

            public void installerEvent(InstallerEvent installerEvent) {
                if (!CustomizableDirectoryScreen.this.getContext().isConsole() && !CustomizableDirectoryScreen.this.getContext().isUnattended() && installerEvent instanceof InstallerVariableEvent && ((InstallerVariableEvent)installerEvent).getVariableName().equals(CustomizableDirectoryScreen.this.variableName)) {
                    CustomizableDirectoryScreen.this.initDirectorySelector();
                    Object object = CustomizableDirectoryScreen.this.getContext().getVariable(CustomizableDirectoryScreen.this.variableName);
                    if (object != null && object instanceof String) {
                        CustomizableDirectoryScreen.this.directorySelector.setDirectory(new File((String)object));
                    } else {
                        CustomizableDirectoryScreen.this.directorySelector.initDirectory(new File(CustomizableDirectoryScreen.this.getUsedInitialDirectory()), CustomizableDirectoryScreen.this.getStandardDirectoryName());
                    }
                }
            }
        });
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        while (true) {
            String string = console.askString(this.getSubTitle(), this.getUsedInitialDirectory());
            try {
                File file = new File(string).getCanonicalFile();
                if (!new File(string).isAbsolute() || file.exists() && !file.isDirectory()) {
                    console.println(MessageFormat.format(this.getMessage("InvalidDirectory"), string));
                    continue;
                }
                if (this.onlyWritable && InstallerUtil.checkWritable(file, null, true)) continue;
                this.setDirectory(file);
                return true;
            }
            catch (IOException iOException) {
                console.println(MessageFormat.format(this.getMessage("InvalidDirectory"), string));
                continue;
            }
            break;
        }
    }

    private void setDirectory(File file) {
        this.getContext().setVariable(this.getVariableName(), file.getPath());
        this.getContext().registerResponseFileVariable(this.getVariableName());
    }

    public boolean next() {
        this.setDirectory(this.getSelectedDir());
        return super.next();
    }

    public void willActivate() {
        super.willActivate();
        this.initDirectorySelector();
    }

    private void initDirectorySelector() {
        if (!this.initialized) {
            this.directorySelector.initDirectory(new File(this.getUsedInitialDirectory()), this.getStandardDirectoryName());
            this.initialized = true;
        }
    }

    public void activated() {
        super.activated();
        this.directorySelector.focusTextField();
    }

    protected boolean checkCompleted() {
        boolean bl;
        boolean bl2 = bl = this.directorySelector.checkSelectedDirectory() && super.checkCompleted();
        if (bl) {
            File file = this.getSelectedDir();
            return !this.onlyWritable || InstallerUtil.checkWritable(file, Util.getParentWindow(), true);
        }
        return false;
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(this.infoText, jPanel, gridBagConstraints);
        gridBagConstraints.insets.top = 25;
        jPanel.add((Component)this.directorySelector, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
    }

    public boolean isFillVertical() {
        return false;
    }

    protected void setupControls() {
        super.setupControls();
        this.directorySelector = new DirectorySelector(this.directoryDescription, false);
        this.directorySelector.activateNextScreenOnEnter(this.getContext().getWizardContext());
    }

    private File getSelectedDir() {
        this.initDirectorySelector();
        return this.directorySelector.getSelectedFile();
    }
}

