### R code from vignette source 'DOSE.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=60)
require(DOSE)


###################################################
### code chunk number 2: DOSE.Rnw:65-67
###################################################
library(DOSE)
help(DOSE)


###################################################
### code chunk number 3: DO Similarity
###################################################
data(DO2EG)
set.seed(123)
terms <- list(a=sample(names(DO2EG), 5),b= sample(names(DO2EG), 6))
terms
## Setting Parameters...
params <- new("DOParams", IDs=terms, type="DOID", method="Wang")
## Calculating Semantic Similarities...
sim(params)


###################################################
### code chunk number 4: DO Similarity 2
###################################################
params <- new("DOParams",
              IDs=terms,
              type="DOID",
              method="Wang",
              combine="BMA")
sim(params)


###################################################
### code chunk number 5: Gene Similarity
###################################################
geneid <- list(a=c("5320", "338"),
               b= c("341", "581", "885"))
params <- new("DOParams",
              IDs=geneid,
              type="GeneID",
              method="Wang",
              combine="BMA")
x <- sim(params)
x


###################################################
### code chunk number 6: simplot
###################################################
simplot(x)


###################################################
### code chunk number 7: enrichment analysis
###################################################
data(AL1)
x <- enrichDO(AL1, pvalueCutoff=0.05)
head(summary(x))


###################################################
### code chunk number 8: set readable
###################################################
setReadable(x) <- TRUE
head(summary(x))


###################################################
### code chunk number 9: BARPLOT
###################################################
plot(x, type="bar")


###################################################
### code chunk number 10: CNETPLOT
###################################################
plot(x, categorySize="geneNum", output="fixed")


###################################################
### code chunk number 11: AL1 expression
###################################################
AL1expr


###################################################
### code chunk number 12: CNETPLOT_logFC
###################################################
plot(x,showCategory=5, logFC=AL1expr, categorySize="geneNum",output="fixed")


###################################################
### code chunk number 13: DOSE.Rnw:335-336
###################################################
sessionInfo()


