### Name: gfp
### Title: Yeast GFP Fusion Data
### Aliases: gfp
### Keywords: datasets

### ** Examples

data(gfp)
keep <- names(which(table(gfp$localization_summary) > 50))

if (require(lattice)) {
  bwplot(reorder(localization_summary, abundance, median, na.rm = TRUE) ~ log2(abundance), gfp,
         varwidth = TRUE,
         subset = localization_summary %in% keep)
} else {

  opar <- par(las = 2, mar = par("mar") + c(3.5, 0, 0, 0))
  gfp._sub <- subset(gfp, localization_summary %in% keep)
  gfp._sub$localization_summary <- gfp._sub$localization_summary[, drop = TRUE]
  boxplot(log2(abundance) ~ reorder(localization_summary, abundance, median, na.rm = TRUE), 
          data = gfp._sub, varwidth = TRUE)
  rm(gfp._sub)
  par(opar)

}




