### Name: mgug4120aPMID2PROBE
### Title: Map between PubMed Identifiers and Manufacturer Identifiers
### Aliases: mgug4120aPMID2PROBE
### Keywords: datasets

### ** Examples

    # Convert the object to a list
    xx <- as.list(mgug4120aPMID2PROBE)
    if(length(xx) > 0){
        # Get the probe identifiers for the first two PubMed identifiers
        xx[1:2]
        # Get the first one
        xx[[1]]
        if(interactive() && require(annotate)){
            # Get article information as XML files for a PubMed id
            xmls <- pubmed(names(xx)[1], disp = "data")
            # View article information using a browser
            pubmed(names(xx)[1], disp = "browser")
        }
    }



