### Name: egohomologyDATA
### Title: Genes that are Homologous to Eremothecium gossypii
### Aliases: egohomologyDATA
### Keywords: datasets

### ** Examples

    require("annotate") || stop("annotate unavailable")
    # Convert homologyDATA to a list
    xx <- as.list(egohomologyDATA)

    if(length(xx) > 0){
        # Gets the homology data for the first key of egohomologyDATA
        homodata <- xx[[1]]
        # Gets the organism name, Entrez Gene identifier. internal HomoloGene identifier,
        # GenBank accession number, type of similarity, percent
        # similarity, and URL for percent similarity for the first
        # homoData object in the list obtained previously
        homodata[[1]][["homoOrg"]]
        homodata[[1]][["homoHGID"]]
        homodata[[1]][["homoType"]]
        homodata[[1]][["homoPS"]]
        homodata[[1]][["homoURL"]]
        # Gets the values for more than one keys
        xx[1:3]
    }



