### Name: GOALLENTREZID
### Title: Annotation of GO identifiers by all the corresponding Entrez
###   Gene identifiers
### Aliases: GOALLENTREZID GOALLLOCUSID
### Keywords: datasets

### ** Examples

        require("GO") || stop("GO unavailable")
        # Convert the environment object to a list
        xx <- as.list(GOALLENTREZID)
        # Remove GO identifiers that are not mapped to any Entrez Gene identifier
        xx <- xx[!is.na(xx)]
        if(length(xx) > 0){
                # Get the Entrez Gene identifiers for the first two elents of xx
                llids  <- xx[1:2]
                # Get the evidence code llids
                evds <- sapply(llids, names)
        }




