### Name: pairs.CSP
### Title: Contour/Hexbin Scatterplot Matrices
### Aliases: pairs.CSP
### Keywords: hplot

### ** Examples

  if (interactive()){
    if (require(rfcdmin)){
      data.there<-is.element(c("st.1829", "unst.1829", "st.DRT",
                    "unst.DRT"),objects())

      if ( ( sum(data.there) != length(data.there) )){
         ## obtaining the FCS objects from VRC data
        data(VRCmin)
      }

      ## subsetting the data for quicker plot display of less data
      data.mat1<-st.DRT@data[1:10000, 1:5]

      ## hexagonal binning

      pairs.CSP(data.mat1, alternate.hexbinplot=TRUE)

      ## rectangular binning with legends 

      pairs.CSP(data.mat1, numlev=3,
         image.col=heat.colors(20))

      ## rectangular binning without legends 

      pairs.CSP(data.mat1, numlev=3,
         image.col=heat.colors(20),
         lower.panel=ContourScatterPlot)

      ## putting a box around the observations
      ## greater than 500 for the second variable
      ##  less than 200 for the first variable
      idx1<-which(data.mat1[,2] > 500)  ## green box
      idx2<-which(data.mat1[,1] < 200)  ## blue box

      box.idx.list<-list(idx1, idx2)
      ## hexbin plots
      pairs.CSP(data.mat1, box.idx.list=box.idx.list,
            alternate.hexbinplot=TRUE, border.vec=c("green", "blue"))
      ## rectangular binned plots
      pairs.CSP(data.mat1, box.idx.list=box.idx.list,
            alternate.hexbinplot=FALSE,border.vec=c("green", "blue"),
            lower.panel=ContourScatterPlot)
    }
  }



