### Name: activeMod
### Title: Functional classification of gene groups
### Aliases: activeMod
### Keywords: methods

### ** Examples

## Loading a little dataset
data(gastro)

## Doing functional classification of gene groups for 'Tissue' sample label
gastro.mod = activeMod(gastro.summ, sLabelID="Tissue", cutExp=1,
  cutPhiper=0.05)

## Doing functional classification of gene groups together with the
## networks given by Paths slot for 'Tissue' sample label. Also we are
## using a cuttoff for p-value of hipergeometric test as 0.1
gastro.mod = activeMod(gastro.summ, sLabelID="Tissue", cutExp=1,
  cutPhiper=0.1, usePaths=TRUE)



