### Name: transform.madata
### Title: Micro Array experiment data transformation
### Aliases: transform.madata
### Keywords: smooth

### ** Examples

# load in data
data(kidney)
# do regional loess on raw data
## Not run: 
##D raw.lowess <- transform.madata(kidney.raw, method="rlowess")
##D graphics.off()
##D #do shift without displaying the plot 
##D data1.shift <- transform.madata(kidney.raw, method="shift", lolim=-50, 
##D      uplim=50,draw="off")
##D 
##D # do global lowess and output the plots to a postscript file
##D postscript(file="glowess.ps")
##D data1.glowess <- transform.madata(kidney.raw, method="glowess", draw="dev")
##D graphics.off()
##D 
##D # do linear-log
##D data1.linlog <- transform.madata(kidney.raw, method="linlog")
##D graphics.off()
##D 
##D # do linear-log shift
##D data1.linlogshift <- transform.madata(kidney.raw, method="linlogshift", 
##D   lolim=-50, uplim=50)
##D graphics.off()
## End(Not run)



