### Name: hexplom
### Title: Scatter Plot Matrices
### Aliases: hexplom hexplom.data.frame hexplom.formula
### Keywords: hplot

### ** Examples

  ## Simple hexplom
  data(NHANES)
  hexplom(~NHANES[,7:14],xbins=15)
  ## With colors and conditioning
  hexplom(~NHANES[,9:13]|Sex,data=NHANES,xbins=15,colramp=magent)
  ## With custom panel function
  hexplom(~NHANES[,9:13],data=NHANES,xbins=20,colramp=BTY,
           superpanel=hppan<-function(z,...){
                        panel.pairs(z,upper.panel=panel.hexboxplot,...)})
  



