### Name: toFile
### Title: Render a graph in a file with given format
### Aliases: toFile
### Keywords: models

### ** Examples


library("graph")
library("Rgraphviz")

g1_gz <- gzfile(system.file("GXL/graphExample-01.gxl.gz",package="graph"), open="rb")
g1 <- fromGXL(g1_gz)
ag <- agopen(g1, name="test")

toFile(ag, layoutType="dot", filename="g1_dot.svg", fileType="svg")
toFile(ag, layoutType="neato", filename="g1_neato.ps", fileType="ps")
toFile(ag, layoutType="twopi", filename="g1_twopi.svg", fileType="svg")
toFile(ag, layoutType="circo", filename="g1_circo.png", fileType="png")




