### Name: GeneIdentifierType-class
### Title: Class "GeneIdentifierType"
### Aliases: GeneIdentifierType-class geneIdType,GeneIdentifierType-method
###   show,GeneIdentifierType-method AnnotationIdentifier-class
###   annotation,AnnotationIdentifier-method
###   initialize,AnnotationIdentifier-method
###   show,AnnotationIdentifier-method NullIdentifier-class
###   EnzymeIdentifier-class GenenameIdentifier-class
###   RefseqIdentifier-class SymbolIdentifier-class UnigeneIdentifier-class
###   EntrezIdentifier-class
### Keywords: classes

### ** Examples

getSubclasses(getClass("GeneIdentifierType"))

# create an AnnotationIdentifier, and ask it's type
geneIdType(AnnotationIdentifier(annotation="hgu95av2"))

# Construct a GeneSet from an ExpressionSet, using the 'annotation'
# field of ExpressionSet to recognize the genes as AnnotationType
data(sample.ExpressionSet)
gs <- GeneSet(sample.ExpressionSet[100:109],
              setName="sample.GeneSet", setIdentifier="123")
geneIdType(gs) # AnnotationIdentifier

## Read a Broad set from the system (or a url), and discover their
## GeneIdentifierType
fl <- system.file("extdata", "Broad.xml", package="GSEABase")
bsets <- getBroadSets(fl)
sapply(bsets, geneIdType)

## try to combine gene sets with different set types
try(gs & sets[[1]])

## Not run: 
##D ## Use the annotation package associated with the original
##D ## ExpressionSet to map to EntrezIdentifier() ...
##D geneIdType(gs) <- EntrezIdentifier()
##D ...## and try again
##D gs & bsets[[1]]
##D 
##D ## Another way to change annotation to Entrez (or other) ids
##D probeIds <- featureNames(sample.ExpressionSet)[100:109]
##D geneIds <- as.character(unlist(mget(probeIds, hgu95av2ENTREZID)))
##D GeneSet(EntrezIdentifier(),
##D         setName="sample.GenSet2", setIdentifier="101",
##D         geneIds=geneIds)
## End(Not run)

## Create a new identifier
setClass("FooIdentifier",
         contains="GeneIdentifierType",
         prototype=prototype(
           type=new("ScalarCharacter", "Foo")))
## Create a constructor (optional)
FooIdentifier <- function() new("FooIdentifier")
geneIdType(FooIdentifier())

## tidy up
removeClass("FooIdentifier")



