crit.fun              package:EBarrays              R Documentation

_F_i_n_d _p_o_s_t_e_r_i_o_r _p_r_o_b_a_b_i_l_i_t_y _t_h_r_e_s_h_o_l_d _t_o _c_o_n_t_r_o_l _F_D_R

_D_e_s_c_r_i_p_t_i_o_n:

     Find posterior probability threshold to control FDR

_U_s_a_g_e:

     crit.fun(x, cc) 

_A_r_g_u_m_e_n_t_s:

       x: x is one minus the posterior probabilities of being in a
          specific DE pattern. If there is only one DE pattern, then x
          is the posterior probabilities of being EE.

      cc: cc is FDR to be controlled. For example, to control FDR at
          0.05, set cc=0.05.

_V_a_l_u_e:

     'crit.fun' returns a threshold so that if used in identifying
     genes in a specific DE pattern, FDR can be controlled at cc. Those
     genes with posterior probability of being in that specific DE
     pattern greater than this threshold are claimed to be in that
     specific DE pattern.

_A_u_t_h_o_r(_s):

     Ming Yuan, Ping Wang, Deepayan sarkar, Michael Newton, and
     Christina Kendziorski

_R_e_f_e_r_e_n_c_e_s:

     Newton, M.A., Noueiry, A., Sarkar, D., and Ahlquist, P. (2004).
     Detecting differential gene expression with a semiparametric
     hierarchical mixture model. _Biostatistics_ *5*, 155-176.

_E_x_a_m_p_l_e_s:

     data(gould)
     pattern <- ebPatterns(c("1,1,1,0,0,0,0,0,0,0",
                             "1,2,2,0,0,0,0,0,0,0"))
     gg.em.out <- emfit(gould, family = "GG", hypotheses = pattern, num.iter = 10)
     gg.post.out <- postprob(gg.em.out, gould)$pattern 
     gg.crit <- crit.fun(gg.post.out[,1],0.05)
     # number of DE genes 
     sum(gg.post.out[,2] > gg.crit)

     pattern4 <- ebPatterns(c("1, 1, 1, 1, 1, 1, 1, 1, 1, 1", 
                              "1, 2, 2, 2, 2, 2, 2, 2, 2, 2", 
                              "1,2,2,1,1,1,1,1,2,2", 
                              "1,1,1,1,1,1,1,1,2,2"))
     gg4.em.out <- emfit(gould, family = "GG", pattern4, num.iter = 10)
     gg4.post.out <- postprob(gg4.em.out, gould)$pattern
     gg4.crit <- crit.fun(1-gg4.post.out[,2], 0.05)
     # number of genes in pattern 2, a DE pattern
     sum(gg4.post.out[,2] > gg4.crit)

