### Name: comp.stat
### Title: Computing Test Statistics for Differential Expression
### Aliases: comp.stat
### Keywords: univar

### ** Examples

X <- matrix(rnorm(1000,0,0.5), nc=10)
L <- rep(0:1,c(5,5))

# genes 1-10 are differentially expressed
X[1:10,6:10]<-X[1:10,6:10]+1

# t statistics
tstat <- comp.stat(X, L, test="t")

# SAM, fudge factor set as the median of pooled genewise standard deviations
samstat <- comp.stat(X, L, test="sam")
# SAM, fudge factor set as the 90% of pooled genewise standard deviations
samstat <- comp.stat(X, L, test="sam", extra=c(0.9))

# moderated t
modtstat <- comp.stat(X, L, test="modt")

# B, proportion of differentially expressed genes is set at default, 1%
Bstat <- comp.stat(X, L, test="B")
# B, proportion of differentially expressed genes is set at  10%
Bstat <- comp.stat(X, L, test="B", extra=c(0.1))



