### Name: segmentData
### Title: Breakpoint detection for arrayCGH data.
### Aliases: segmentData
### Keywords: misc

### ** Examples

  data(Wilting)
  ## First preprocess the data
  raw.data <- preprocess(Wilting, type="dataframe")
  ## Simple global median normalization for samples with 75% tumor cells
  perc.tumor <- rep(0.75, 3)
  normalized.data <- normalize(raw.data, cellularity=perc.tumor)
  ## Segmentation with slightly relaxed significance level to accept change-points.
  ## Note that segmentation can take a long time.
  ## Not run: segmented.data <- segmentData(normalized.data, alpha=0.02)



