### Name: align-utils
### Title: Utility functions related to sequence alignment
### Aliases: consmat consmat,matrix-method consmat,character-method
###   consmat,list-method consmat,BStringViews-method
### Keywords: methods

### ** Examples

  file <- system.file("Exfiles", "someORF.fsa", package="Biostrings")
  orf <- read.BStringViews(file, "fasta", "DNAString")

  ## To illustrate, the following example assumes the ORF data
  ## to be aligned for the first 10 positions (patently false):
  orf10 <- subviews(orf, 1, 10)
  consmat(orf10)

  ## For the character matrix containing the "exploded" representation
  ## of the views, do:
  as.matrix(orf10, mode="character")



