### Name: BStringViews-constructors
### Title: Basic functions for creating BStringViews objects
### Aliases: BStringViews-constructors views adjacentViews BStringViews
###   BStringViews,ANY-method BStringViews,file-method
###   BStringViews,BString-method BStringViews,BStringViews-method
### Keywords: methods

### ** Examples

  ## 'start' and 'end' are recycled
  views("abcdefghij", 2:1, 4)
  views("abcdefghij", 5:7, )
  views("abcdefghij", , 5:7)

  ## Views can be "out of limits"
  views("abcdefghij", 2:0, 4)

  ## Views on a DNAString object
  v12 <- views(DNAString("TAATAATG"), -2:9, 0:11)

  ## Creating adjacent views
  v3 <- adjacentViews("abcdefghij", 4:2, gapwidth=1)

  BStringViews(v12, subjectClass="RNAString")
  BStringViews(AAString("MARKSLEMSIR*"))
  BStringViews("abcdefghij", subjectClass="BString")



