### Name: BSgenome-class
### Title: The BSgenome class
### Aliases: class:BSgenome BSgenome-class BSgenome organism
###   organism,BSgenome-method species species,BSgenome-method provider
###   provider,BSgenome-method providerVersion
###   providerVersion,BSgenome-method releaseDate
###   releaseDate,BSgenome-method releaseName releaseName,BSgenome-method
###   sourceUrl sourceUrl,BSgenome-method seqnames seqnames,BSgenome-method
###   mseqnames mseqnames,BSgenome-method names,BSgenome-method
###   initialize,BSgenome-method show,BSgenome-method
###   length,BSgenome-method [[,BSgenome-method [[<-,BSgenome-method
###   $,BSgenome-method unload unload,BSgenome-method
### Keywords: methods classes

### ** Examples

  library(BSgenome.Celegans.UCSC.ce2)   # This doesn't load the chromosome 
                                        # sequences into memory.
  length(Celegans)                      # Number of sequences in this genome.
  Celegans                              # Displays a summary of the sequences
                                        # provided in this genome.
  seqnames(Celegans)                    # Index of single sequences.
  class(Celegans$chrI)                  # A DNAString instance.
  mseqnames(Celegans)                   # Index of multiple sequences.
  class(Celegans$upstream1000)          # A BStringViews instance.
  desc(Celegans$upstream1000)[1:4]      # Character vector containing the
                                        # description line found in the FASTA
                                        # file for the first 4 FASTA records.

  ## Some important considerations about memory usage:
  mem0 <- gc()["Vcells", "(Mb)"]        # Current amount of data in memory (in
                                        # Mb).
  Celegans[["chrV"]]                    # Loads chromosome V into memory (hence
                                        # takes a long time).
  gc()["Vcells", "(Mb)"] - mem0         # Chromosome V occupies 20Mb of memory.
  Celegans[["chrV"]]                    # Much faster (sequence is already in
                                        # memory, hence it's not loaded again).
  Celegans$chrV                         # Equivalent to Celegans[["chrV"]].
  class(Celegans$chrV)                  # Chromosome V (like any other
                                        # chromosome sequence) is a DNAString
                                        # object.
  nchar(Celegans$chrV)                  # It has 20922231 letters (nucleotides).
  x <- Celegans$chrV                    # Very fast because a BString object
                                        # doesn't contain the sequence, only a
                                        # pointer to the sequence, hence chrV
                                        # seq is not duplicated in memory. But
                                        # we now have 2 objects pointing to the
                                        # same place in memory.
  y <- substr(x, 10, 100)               # A 3rd object pointing to chrV seq.
  
  ## We must remove all references to chrV seq if we want the 20Mb of memory
  ## used by it to be freed (note that it can be hard to keep track of all the
  ## references to a given sequence).
  ## IMPORTANT: The 1st reference to this seq (Celegans$chrV) should be removed
  ## last. This is achieved with unload(). All other references are removed by
  ## just removing the referencing object.
  rm(x)
  rm(y)
  unload(Celegans, "chrV")
  gc()["Vcells", "(Mb)"]



