### Name: AnnDbObj-objects
### Title: AnnDbObj objects
### Aliases: AnnDbObj-objects AnnDbObj class:AnnDbObj AnnDbObj-class dbconn
###   dbconn,environment-method dbconn,AnnDbObj-method dbfile
###   dbfile,environment-method dbfile,AnnDbObj-method dbmeta
###   dbmeta,DBIConnection-method dbmeta,environment-method
###   dbmeta,AnnDbObj-method dbschema dbschema,DBIConnection-method
###   dbschema,environment-method dbschema,AnnDbObj-method dbInfo
###   dbInfo,DBIConnection-method dbInfo,environment-method
###   dbInfo,AnnDbObj-method
### Keywords: classes methods

### ** Examples

  library(hgu95av2.db)

  dbconn(hgu95av2ENTREZID)              # same as hgu95av2_dbconn()
  dbfile(hgu95av2ENTREZID)              # same as hgu95av2_dbfile()

  dbmeta(hgu95av2_dbconn(), "ORGANISM")
  dbmeta(hgu95av2_dbconn(), "DBSCHEMA")
  dbmeta(hgu95av2_dbconn(), "DBSCHEMAVERSION")

  dbListTables(hgu95av2_dbconn())
  dbListFields(hgu95av2_dbconn(), "probes")
  dbListFields(hgu95av2_dbconn(), "genes")
  dbschema(hgu95av2ENTREZID)            # same as hgu95av2_dbschema()
  ## According to the schema, the probes.id column references the genes.id
  ## column. Note that in all tables, the "id" column is an internal id with
  ## no biological meaning (provided for allowing efficient joins between
  ## tables).
  ## To retrieve the mapping between manufacturer IDs and Entrez Gene IDs:
  dbGetQuery(hgu95av2_dbconn(), "SELECT * FROM probes INNER JOIN genes USING (id) LIMIT 10")
  ## This mapping is in fact the ENTREZID map:
  toTable(hgu95av2ENTREZID)[1:10, ] # only relevant columns are retrieved

  dbInfo(hgu95av2GO)                    # same as hgu95av2_dbInfo()



