### Name: interaction.result2html
### Title: output differentially expressed genes for the interaction model
###   to a HTML file
### Aliases: interaction.result2html
### Keywords: misc

### ** Examples

data(testData)
normaldata<-pre.process("rma",testData)

## Create design matrix for interaction effect between "group"
## and "gender"
design.int<-make.design(pData(normaldata), c("group", "gender"), int=c(1,2))

## Create the interaction contrast
contrast.int<-make.contrast(design.int, interaction=TRUE)

## Run Regression to detect interaction effect
result.int<-regress(normaldata, design.int, contrast.int, "L")

## Select differentally expressed genes based on p.value
select.int<-select.sig.gene(result.int, p.value=0.05)

## Identify genes with the interaction effect
sig.ID<-select.int$ID[select.int$significant==TRUE]
sig.index<-match(sig.ID, rownames(exprs(normaldata)))

## Create separate tables for each level of effect modifier
result<-post.interaction("group","M", "F", design.int, normaldata[sig.index,],
  "L","none", 0.05, log2(1.5))

## Output significant result for the interaction model
interaction.result2html(annotation(normaldata), result, result.int, filename="interaction")



