### Name: mt.sample.teststat
### Title: Permutation distribution of test statistics and raw (unadjusted)
###   p-values
### Aliases: mt.sample.teststat mt.sample.rawp mt.sample.label
### Keywords: manip

### ** Examples


# Gene expression data from Golub et al. (1999)
data(golub)

mt.sample.label(golub.cl,B=10)

permt<-mt.sample.teststat(golub[1,],golub.cl,B=1000)
qqnorm(permt)
qqline(permt)

permt<-mt.sample.teststat(golub[50,],golub.cl,B=1000)
qqnorm(permt)
qqline(permt)

permp<-mt.sample.rawp(golub[1,],golub.cl,B=1000)
hist(permp)



