### Name: fom
### Title: Figure of Merit
### Aliases: fom
### Keywords: models

### ** Examples

# load in data
data(paigen)
# make data object with rep 2
paigen <- createData(paigen.raw, 2)
# make interactive model
model.int.fix <- makeModel(data=paigen,
      formula=~Dye+Array+Strain+Diet+Strain:Diet)
# fit ANOVA model
## Not run: 
##D anova.int <- fitmaanova(paigen, model.int.fix)
##D # test interaction effect 
##D test.int.fix <- matest(paigen, model.int.fix, term="Strain:Diet", n.perm=100)
##D # pick significant genes - pick the genes selected by Fs test
##D idx <- volcano(test.int.fix)$idx.Fs
##D # generate FOM
##D m <- fom(anova.int, idx, "Strain:Diet", 10)
## End(Not run)



