/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.experiment.datamatrix;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.systemsbiology.gaggle.experiment.metadata.MetaData;

public class DataMatrix
implements Serializable {
    String rowTitlesTitle;
    String[] columnTitles = new String[0];
    String[] rowTitles = new String[0];
    double[][] data = null;
    String uri = "";
    String fullName = "";
    String shortName = "";
    String fileExtension;
    String dataTypeBriefName;
    String species = "unknown";
    ArrayList metaDataList;

    public DataMatrix() {
        this("");
    }

    public DataMatrix(String string) {
        this.uri = string.trim();
        this.fullName = string;
        this.shortName = this.calculateShortName();
        this.dataTypeBriefName = this.fileExtension = this.calculateFileExtension();
        this.metaDataList = new ArrayList();
    }

    public void addMetaData(MetaData metaData) {
        this.metaDataList.add(metaData);
    }

    public void addMetaData(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.metaDataList.add((MetaData)arrayList.get(i));
        }
    }

    public boolean hasMetaData() {
        return this.metaDataList.size() > 0;
    }

    public MetaData[] getMetaData() {
        return this.metaDataList.toArray(new MetaData[0]);
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setSpecies(String string) {
        this.species = string;
    }

    public String getSpecies() {
        return this.species;
    }

    protected String calculateShortName() {
        String[] stringArray = this.fullName.split("/");
        int n = stringArray.length - 1;
        if (n < 0) {
            return this.fullName;
        }
        return stringArray[n];
    }

    protected String calculateFileExtension() {
        String string = this.getShortName();
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getDataTypeBriefName() {
        return this.dataTypeBriefName;
    }

    public void setDataTypeBriefName(String string) {
        this.dataTypeBriefName = string;
    }

    public void setFullName(String string) {
        this.fullName = string;
        this.shortName = this.calculateShortName();
        this.fileExtension = this.calculateFileExtension();
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setSize(int n, int n2) {
        this.data = new double[n][n2];
    }

    public void setDefault(double d) {
        if (this.data == null) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                this.data[i][j] = d;
            }
        }
    }

    public void set(int n, int n2, double d) {
        this.data[n][n2] = d;
    }

    public void set(int n, double[] dArray) {
        this.data[n] = dArray;
    }

    public void addRow(String string, double[] dArray) throws IllegalArgumentException {
        if (dArray.length != this.getColumnCount()) {
            throw new IllegalArgumentException("new row must have only " + this.getColumnCount() + " values; you supplied " + dArray.length);
        }
        int n = this.getRowCount() + 1;
        double[][] dArray2 = new double[n][this.getColumnCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            dArray2[i] = this.data[i];
        }
        dArray2[n - 1] = dArray;
        this.data = dArray2;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.rowTitles));
        arrayList.add(string);
        this.rowTitles = arrayList.toArray(new String[0]);
    }

    public void setColumnTitles(String[] stringArray) {
        this.columnTitles = stringArray;
    }

    public void setRowTitles(String[] stringArray) {
        this.rowTitles = stringArray;
    }

    public void setRowTitlesTitle(String string) {
        this.rowTitlesTitle = string;
    }

    public int getRowCount() {
        if (this.data != null) {
            return this.data.length;
        }
        return 0;
    }

    public int getColumnCount() {
        if (this.columnTitles != null) {
            return this.columnTitles.length;
        }
        return 0;
    }

    public double get(int n, int n2) {
        return this.data[n][n2];
    }

    public double[] get(int n) {
        if (this.data != null) {
            return this.data[n];
        }
        return new double[0];
    }

    public double[] get(String string) {
        for (int i = 0; i < this.rowTitles.length; ++i) {
            if (!this.rowTitles[i].equals(string)) continue;
            return this.data[i];
        }
        throw new IllegalArgumentException("no data for '" + string + "'");
    }

    public String[] getRowTitles() {
        return this.rowTitles;
    }

    public void set(double[][] dArray) {
        this.data = dArray;
    }

    public double[][] get() {
        return this.data;
    }

    public int getColumnNumber(String string) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.columnTitles[i].equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("no column named " + string);
    }

    public int getRowNumber(String string) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.rowTitles[i].equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("no row named " + string);
    }

    public double[] getColumn(String string) {
        int n = this.getColumnNumber(string);
        double[] dArray = new double[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            dArray[i] = this.data[i][n];
        }
        return dArray;
    }

    public double[] getColumn(int n) {
        double[] dArray = new double[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            dArray[i] = this.data[i][n];
        }
        return dArray;
    }

    public String getRowTitlesTitle() {
        return this.rowTitlesTitle;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.columnTitles.length;
        String[] stringArray = this.getColumnTitles();
        stringBuffer.append(this.rowTitlesTitle);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("\t");
            stringBuffer.append(stringArray[n]);
        }
        stringBuffer.append("\n");
        n = this.rowTitles.length;
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.get(i);
            stringBuffer.append(this.rowTitles[i]);
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append("\t");
                stringBuffer.append(dArray[j]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean equals(DataMatrix dataMatrix) {
        return this.toString().equals(dataMatrix.toString());
    }

    public void writeObject(String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
    }

    public static DataMatrix readObject(String string) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        DataMatrix dataMatrix = (DataMatrix)objectInputStream.readObject();
        return dataMatrix;
    }
}

