### Name: norm.arrayCGH
### Title: Normalize an object of type arrayCGH
### Aliases: norm.arrayCGH MANOR manor


### ** Examples

data(spatial)
data(flags)

### 'edge': local spatial bias
## define a list of flags to be applied
flag.list1 <- list(spatial=local.spatial.flag, spot=spot.corr.flag,
ref.snr=ref.snr.flag, dapi.snr=dapi.snr.flag, rep=rep.flag,
unique=unique.flag) 
flag.list1$spatial$args <- alist(var="ScaledLogRatio", by.var=NULL,
nk=5, prop=0.25, thr=0.15, beta=1, family="symmetric") 
flag.list1$spot$args <- alist(var="SpotFlag")
flag.list1$spot$char <- "O"
flag.list1$spot$label <- "Image analysis"

## normalize arrayCGH
## Not run: 
##D edge.norm <- norm.arrayCGH(edge, flag.list=flag.list1,
##D var="LogRatio", FUN=median, na.rm=TRUE)
## End(Not run) 
print(edge.norm$flags) ## spot-level flag summary (computed by flag.summary)

## aggregate arrayCGH without normalization
edge.nonorm <- norm.arrayCGH(edge, flag.list=NULL, var="LogRatio",
FUN=median, na.rm=TRUE)  

## sort genomic informations 
edge.norm <- sort.arrayCGH(edge.norm, position.var="PosOrder")
edge.nonorm <- sort.arrayCGH(edge.nonorm, position.var="PosOrder")

## plot genomic profiles
layout(matrix(c(1,2,4,5,3,3,6,6), 4,2),width=c(1, 4), height=c(6,1,6,1))
report.plot(edge.nonorm, chrLim="LimitChr", layout=FALSE,
main="Pangenomic representation (before normalization)", zlim=c(-1,1),
ylim=c(-3,1))  
report.plot(edge.norm, chrLim="LimitChr", layout=FALSE,
main="Pangenomic representation (after normalization)", zlim=c(-1,1),
ylim=c(-3,1)) 

### 'gradient': global array Trend
## define a list of flags to be applied
flag.list2 <- list(
  spot=spot.flag, global.spatial=global.spatial.flag, SNR=SNR.flag,
  val.mark=val.mark.flag, position=position.flag, unique=unique.flag,
  amplicon=amplicon.flag, replicate=replicate.flag,
  chromosome=chromosome.flag)

## normalize arrayCGH
## Not run: gradient.norm <- norm.arrayCGH(gradient, flag.list=flag.list2, var="LogRatio", FUN=median, na.rm=TRUE) 
## aggregate arrayCGH without normalization
gradient.nonorm <- norm.arrayCGH(gradient, flag.list=NULL, var="LogRatio", FUN=median, na.rm=TRUE) 

## sort genomic informations 
gradient.norm <- sort.arrayCGH(gradient.norm)
gradient.nonorm <- sort.arrayCGH(gradient.nonorm)

## plot genomic profiles
layout(matrix(c(1,2,4,5,3,3,6,6), 4,2),width=c(1, 4), height=c(6,1,6,1))
report.plot(gradient.nonorm, chrLim="LimitChr", layout=FALSE,
main="Pangenomic representation (before normalization)", zlim=c(-2,2),
ylim=c(-3,2)) 
report.plot(gradient.norm, chrLim="LimitChr", layout=FALSE,
main="Pangenomic representation (after normalization)", zlim=c(-2,2),
ylim=c(-3,2)) 



