### Name: watershed
### Title: Watershed transformation and watershed based object detection
### Aliases: watershed
### Keywords: file

### ** Examples

  if ( interactive() ) {
    ddir <- paste( system.file(package="EBImage"), "images", sep="/" )
    a <- read.image( paste(ddir, "A04w1.jpg", sep="/") )

    w <- watershed( distmap( thresh(a, 10, 10) ) )
    display( normalize(w) )

    ## Not run: often one needs to delete small objects
    ## Not run: here is the straightforward way to construct the index
    index <- lapply( getObjects(w), function(x) which( x[, "size"] < 40) )
    w <- rmObjects(w, index)
    display( normalize(w) )

  }



