### Name: GOMFCHILDREN
### Title: Annotation of GO Identifiers to their Molecular Function
###   Children
### Aliases: GOMFCHILDREN
### Keywords: datasets

### ** Examples

    require("GO", character.only = TRUE) || stop("GO unavailable")
    require("annotate", character.only = TRUE) || stop("annotate unavailable")
    # Convert the environment object to a list
    xx <- as.list(GOMFCHILDREN)
    # Remove GO identifiers that do not have any children
    xx <- xx[!is.na(xx)]
    if(length(xx) > 0){
        # Get the children GO identifiers for the first elents of xx
        goids <- xx[[1]]
        # Find out the GO terms for the first parent goid
        GOID(GOTERM[[goids[1]]])
        Term(GOTERM[[goids[1]]])
        Synonym(GOTERM[[goids[1]]])
        Secondary(GOTERM[[goids[1]]])
        Definition(GOTERM[[goids[1]]])
        Ontology(GOTERM[[goids[1]]])
    }



