### Name: GOENTREZID
### Title: Gene Ontology (GO) to Entrez Gene Mapping
### Aliases: GOENTREZID GOLOCUSID
### Keywords: datasets

### ** Examples

    require("GO") || stop("GO unavailable")
    # Convert the environment object to a list
    xx <- as.list(GOENTREZID)
    # Remove GO identifiers that are not mapped to any Entrez Gene id
    xx <- xx[!is.na(xx)]
    if(length(xx) > 0){
        # Get the Entrez Gene identifiers for the first two elents of xx
        llids  <- xx[1:2]
        # Get the evidence code llids
        evds <- sapply(llids, names)
    }



