### Name: stam.predict
### Title: Predict Classifications of New Data
### Aliases: stam.predict
### Keywords: classif

### ** Examples

# load and prepare data
library(golubEsets)
data(Golub_Merge)
golubTest <- Golub_Merge[,39:72]
data(golubTrain.fit)

# compute predictions
golubTest.pred <- stam.predict(golubTrain.fit, golubTest, 
                               pData(golubTest)[,"ALL.AML"])
golubMerge.pred <- stam.predict(golubTrain.fit, Golub_Merge, 
                                pData(Golub_Merge)[,"ALL.AML"], testset=39:72)

# further investigate
print(golubTest.pred)
plot(golubTest.pred)
## Not run: 
##D map <- image(golubMerge.pred, outfile="golubMerge")
##D cat("<HTML><BODY><MAP NAME='image_map'>", map, "</MAP>",
##D     "<IMG SRC='golubMerge_pred_img.png' USEMAP='#image_map'></BODY></HTML>\n", 
##D     file="pred_img.html")
##D browseURL(paste("file://", getwd(), "/pred_img.html", sep=""))
## End(Not run)


