### Name: cset2band
### Title: cset2band
### Aliases: cset2band
### Keywords: manip

### ** Examples


   data(mcr.eset)
   data(idiogramExample)

## Create a vector with the index of normal samples
   norms <- grep("MNC",colnames(mcr.eset@exprs))

## Smooth the data using the default 'movbin' method,
## with the normal samples as reference and median centering
   cset <- reb(mcr.eset,vai.chr,ref=norms,center=TRUE)

## Mask the result to remove noise
   exprs <- cset[,-norms]
   exprs[abs(exprs) < 1.96] <- NA

## Starting data
   midiogram(exprs,vai.chr,method="i",col=.rwb,dlim=c(-4,4))

## Summarize each cytogenetic band
   banded <- cset2band(exprs,vai.chr,FUN=mean,na.rm=TRUE)

## Create chromLocation object based on human cytobands
   h.cyto <- buildChromCytoband(organism = "h")

## Plot all data using mideogram
   midiogram(banded,h.cyto,method="i",col=.rwb,dlim=c(-4,4))




